package com.yizhi.site.application.controller;


import com.yizhi.site.application.domain.AppVersion;
import com.yizhi.site.application.service.IAppVersionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * APP版本控制表 前端控制器
 * </p>
 *
 * @author lingye
 * @since 2019-07-22
 */
@RestController
@RequestMapping("/appVersion")
public class AppVersionController {
    @Autowired
    private IAppVersionService appVersionService;

    /**
     * 获取用版本控制 最新版本
     * @param siteCode
     * @param type
     * @return
     */
    @GetMapping("/get")
    public AppVersion getAppVersion(@RequestParam(name = "siteCode") String siteCode,
                                    @RequestParam(name = "companyCode") String companyCode,
                                    @RequestParam(name = "type") Integer type) {

        return appVersionService.getAppVersionDetail(siteCode,companyCode,type);
    }
}
