package com.yizhi.site.application.controller;


import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.PageFooterItem;
import com.yizhi.site.application.service.IPageFooterItemService;
import com.yizhi.site.application.vo.site.PageFooterVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author liang123
 * @since 2018-12-21
 */
@RestController
@RequestMapping("/manage/page")
public class PageFooterItemController {

    private static Logger Log = LoggerFactory.getLogger(PageFooterItemController.class);
    @Autowired
    private IPageFooterItemService pageFooterItemService;

//    /**
//     * 保存文案
//     * @param pageFooterItem
//     * @return
//     */
//    @PostMapping("/pageFooterItem/save")
//    public PageFooterItemEntityVo pageFooterItemSave(@RequestBody PageFooterItemEntityVo pageFooterItem){
//
//        return pageFooterItemService.save(pageFooterItem);
//    }

    /**
     * 页底信息删除
     *
     * @param id
     * @return
     */
    @GetMapping("/pageFooterItem/delete")
    public Boolean delete(@RequestParam Long id){
        Boolean f = false;
        try{
            f = pageFooterItemService.deleteByPageFooterItem(id);
            return f;
        }catch (Exception e){
            Log.error("删除失败",e);
            return f;
        }


    }

    /**
     * 新增回显查询列表
     *
     * @return
     */
    @GetMapping("/pageFooterItem/getList")
    public PageFooterVO selectPageList(@RequestParam(name = "TerminalType")Integer TerminalType){

        RequestContext context = ContextHolder.get();
        PageFooterVO pageFooterVOList = pageFooterItemService.getList(TerminalType,context.getCompanyId(),context.getOrgId(), context.getSiteId());
        return pageFooterVOList;
    }


    /**
     * 底页查询列表
     *
     * @return
     */
    @GetMapping("/pageFooterItem/get")
    public PageFooterVO selectPage(@RequestParam(name = "TerminalType")Integer TerminalType){

        RequestContext context = ContextHolder.get();
        PageFooterVO pageFooterVOList = pageFooterItemService.getList(TerminalType,context.getCompanyId(),null, context.getSiteId());
        return pageFooterVOList;
    }



    /**
     * 排序(文案、链接)
     *
     * @param list
     * @return
     */
    @PostMapping("/pageFooterItem/sort")
    public Integer pageFooterItemSort(@RequestBody List<PageFooterItem> list) {
        return pageFooterItemService.pageFooterItemSort(list);
    }



}

