package com.yizhi.site.application.controller.api;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.comment.application.feign.PdfPagesClient;
import com.yizhi.comment.application.vo.domain.PdfPagesVo;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.point.application.feign.PointListenerClients;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.domain.Information;
import com.yizhi.site.application.feign.api.EventTrackApiClients;
import com.yizhi.site.application.service.ITrInformationReadNumberService;
import com.yizhi.site.application.service.InformationService;
import com.yizhi.site.application.service.PortalBannerService;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.util.application.constant.TpActivityType;
import io.swagger.annotations.Api;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author mei
 */
@Api(tags = "学员端-新闻资讯", description = "新闻资讯")
@RestController
@RequestMapping("/api/info")
public class InfoStudentController {

    @Autowired
    private InformationService informationService;
    @Autowired
    private PortalBannerService portalBannerService;

    @Autowired
    private ITrInformationReadNumberService informationReadNumberService;
    @Autowired
    private PdfPagesClient pdfPagesClient;

    @Autowired
    private PointListenerClients pointListenerClients;
    /**
     * 获取新闻资讯列表
     */
    @PostMapping("/page/list")
    public InformationListVO informationPageList(@RequestBody InfoVO infoVO) {
        return informationService.informationPageList(infoVO);
    }

    /**
     * 获取新闻资讯banner
     * @param infoVO
     * @return
     */
    @PostMapping("/mobile/bannerImages")
    public List<ImageListVO> listBannerImages(@RequestBody InfoVO infoVO){
        return informationService.listBannerImages(infoVO);
    }

    /**
     * pc端,新闻/公告列表
     *
     * @param infoVO
     * @return
     */
    @PostMapping("/page/pcList")
    public InformationListPcVo informationPcPageList(@RequestBody InfoVO infoVO) {
         InformationListPcVo informationListPcVo = informationService.informationPcPageListV2(infoVO);
        return informationListPcVo;
    }

    /**
     * pc端,新闻/公告列表
     *版本2  公告的查询修改；新增置顶公告
     */
    @PostMapping("/page/v2/pcList")
    public InformationListPcVo informationPcPageListV2(@RequestBody InfoVO infoVO) {
        return informationService.informationPcPageListV2(infoVO);
    }

    /**
     * pc端查看新闻资讯详情
     *
     * @param idOneVO
     * @return
     */
    @PostMapping("/pcView")
    public InformationViewVO getPcInformation(@RequestBody IdOneVO idOneVO) {
        return informationService.getPcInformation(idOneVO);
    }

    /**
     * 获取新闻资讯列表
     */
    @PostMapping("/list")
    public InformationListVO InformationList(@RequestBody InfoVO infoVO) {
        Long typeOne = Long.valueOf(infoVO.getTypeOne());
        Integer pageNo = infoVO.getPageNo() == null ? 1 : infoVO.getPageNo();
        Integer pageSize = infoVO.getPageSize() == null ? 10 : infoVO.getPageSize();
        InformationListVO informationListVO = new InformationListVO();
        Long siteId = infoVO.getContext().getSiteId();
        Page<InformationStudentVO> page = new Page<InformationStudentVO>();
        Page<InformationStudentVO> page1 = new Page<InformationStudentVO>();
        if (typeOne == 1L) {
            page = informationService.informationList(1L, pageNo, pageSize, siteId);
            informationListVO.setInformationOne(page);
            return informationListVO;
        } else if (typeOne == 2L) {
            page1 = informationService.informationList(2L, pageNo, pageSize, siteId);
            informationListVO.setInformationTwo(page1);
            return informationListVO;
        } else {
            AllHomeBannerImageVO avo = new AllHomeBannerImageVO();
            avo.setBannerName(infoVO.getBannerName());
            avo.setTerminalName(infoVO.getTerminalName());
            avo.setCompanyId(infoVO.getContext().getCompanyId());
            avo.setSiteId(infoVO.getContext().getSiteId());
            avo.setOrgId(infoVO.getContext().getOrgId());
            List<ImageListVO> portalImageList = portalBannerService.listAllHomeBannerImage(avo);

            page = informationService.informationList(1L, pageNo, pageSize, siteId);
            page1 = informationService.informationList(2L, pageNo, pageSize, siteId);
            informationListVO.setInformationOne(page);
            informationListVO.setInformationTwo(page1);
            informationListVO.setPortalImageList(portalImageList);
            return informationListVO;
        }
    }

    /**
     * 查看新闻资讯详情
     *
     * @param
     * @return
     */
    @PostMapping("view")
    public InformationViewVO getInformation(@RequestBody IdOneVO vo) {
        Long siteId = vo.getContext().getSiteId();
        Information information = informationService.getInformation(vo.getId(), siteId);

        // 新增阅读次数
        InformationViewVO informationViewVO = new InformationViewVO();
        if (null != information) {
            BeanUtils.copyProperties(information, informationViewVO);
        }else {
            return null;
        }

        informationViewVO.setReadCount(informationReadNumberService.getInformationReadCount(vo.getId()));
        try {
			List<PdfPagesVo> list = pdfPagesClient.list(informationViewVO.getId(), TpActivityType.TYPE_INFORMATION);
            List<com.yizhi.site.application.vo.site.PdfPagesVo> list1=new ArrayList<>();
            for (PdfPagesVo d:list) {
                com.yizhi.site.application.vo.site.PdfPagesVo entityVo=new com.yizhi.site.application.vo.site.PdfPagesVo();
                BeanUtils.copyProperties(d,entityVo);
                list1.add(entityVo);
            }
			if (!CollectionUtils.isEmpty(list1)) {
				informationViewVO.setPdfPages(list1);
			}
            pointListenerClients.addPoint("point_read", vo.getId());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        return informationViewVO;
    }

    /**
     * 首页 搜索新闻公告
     *
     * @param
     * @return
     */
    @PostMapping("/home/search")
    public Page<Information> searchInformation(@RequestBody InfomationParamVO vo) {
        Information info = new Information();
        info.setFileName(vo.getFileName());
        info.setSiteId(vo.getContext().getSiteId());
        info.setState(SiteConstant.TWO);
        Page<Information> page = new Page<Information>(vo.getPageNo(), vo.getPageSize());
        List<Information> list = informationService.searchInformation(page, info);
        page.setRecords(list);
        return page;
    }

}
