package com.yizhi.site.application.controller.api;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.domain.SystemMailbox;
import com.yizhi.site.application.service.SystemMailboxService;
import com.yizhi.site.application.vo.domain.SystemMailboxConditionVo;
import com.yizhi.site.application.vo.domain.SystemMailboxParamVo;
import com.yizhi.site.application.vo.domain.SystemMailboxVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * com.yizhi.site.application.controller.api
 *
 * @author yanglang
 * @create 2025-01-09 14:24:07
 */
@RestController
@RequestMapping("/systemMailbox")
public class SystemMailboxController {

    @Autowired
    private SystemMailboxService systemMailboxService;

    @PostMapping("selectPage")
    public Page<SystemMailbox> selectPage(@RequestBody SystemMailboxConditionVo conditionVo){
        return systemMailboxService.selectPage(conditionVo);
    }

    @PostMapping("save")
    public Long save(@RequestBody SystemMailboxVo systemMailBoxVo){
        return systemMailboxService.save(systemMailBoxVo);
    }

    @GetMapping("getById")
    public SystemMailboxVo getById(@RequestParam("id") Long id){
        return systemMailboxService.getById(id);
    }

    @GetMapping("removeById")
    public Boolean removeById(@RequestParam("id")Long id){
        return systemMailboxService.removeById(id);
    }

    @GetMapping("selectMyPage")
    public Page<SystemMailboxParamVo> selectMyPage(@RequestParam("pageNo")Integer pageNo, @RequestParam("pageSize")Integer pageSize, @RequestParam("type")Integer type){
        return systemMailboxService.selectMyPage(pageNo,pageSize, type);
    }
}
