package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import com.baomidou.mybatisplus.enums.IdType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * APP版本控制表
 * </p>
 *
 * @author lingye
 * @since 2019-07-22
 */
@Data
@Api(tags = "AppVersionEntityVo", description = "APP版本控制表")
@TableName("app_version")
public class AppVersion extends Model<AppVersion> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "应用安装包地址")
    @TableField("app_url")
    private String appUrl;

    @ApiModelProperty(value = "类型：1 IOS，2 Android")
    private Integer type;

    @ApiModelProperty(value = "站点id")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "站点Code")
    @TableField("site_code")
    private String siteCode;

    @ApiModelProperty(value = "公司Code")
    @TableField("company_code")
    private String companyCode;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "版本号")
    private String version;

    @ApiModelProperty(value = "app_des")
    private String appDes;

    @ApiModelProperty(value = "删除标记,1 删除，0 正常")
    @TableField(value = "del_flag")
    private Integer delFlag;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
