package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author liang123
 * @since 2018-12-21
 */
@Data
@Api(tags = "PageFooterItemEntityVo", description = "")
@TableName("page_footer_item")
public class PageFooterItem extends Model<PageFooterItem> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键id")
    private Long id;

    @TableField("page_footer_id")
    private Long pageFooterId;

    @ApiModelProperty(value = "0文案 / 1链接")
    @TableField("page_type")
    private Integer pageType;

    @ApiModelProperty(value = "0文字连接,1图片链接")
    private Integer type;

    @ApiModelProperty(value = "链接名称")
    private String name;

    @ApiModelProperty(value = "文案")
    @TableField("official_document_content")
    private String officialDocumentContent;

    @ApiModelProperty(value = "是否显示:0不显示,1显示")
    private Integer showable;

    @ApiModelProperty(value = "0 未删除   1 删除")
    private Integer delete;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "企业_ID")
    @TableField("company_id")
    private Long companyId;

    @ApiModelProperty(value = "站点_ID")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "部门_ID")
    @TableField("org_id")
    private Long orgId;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "创建人id")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @ApiModelProperty(value = "修改人id")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "修改人名")
    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
