package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@Api(tags = "RelationReportEntityVo", description = "")
@TableName("relation_report")
public class RelationReport {


    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
	@TableId(value="id")
	private Long id;

    @ApiModelProperty(value = "终端ID")
	@TableField("terminal_id")
	private Long terminalId;

    @ApiModelProperty(value = "关联的报告id")
	@TableField("report_id")
	private Long reportId;

    @ApiModelProperty(value = "关联的报告名称")
	@TableField("report_name")
	private String reportName;
    
    @ApiModelProperty(value = "状态")
    private Integer state;

    @ApiModelProperty(value = "是否置顶")
	@TableField("is_top")
    private Integer isTop;
    
    @ApiModelProperty(value = "推送开始时间")
	@TableField("start_push")
    private Date startPush;
    
    @ApiModelProperty(value = "推送结束时间") 
	@TableField("end_push")
    private Date endPush;
    
    @ApiModelProperty(value = "统计开始时间")
	@TableField("start_time")
    private Date startTime;
    
    @ApiModelProperty(value = "统计结束时间") 
	@TableField("end_time")
    private Date endTime;
    
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;
}
