package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "SiteManageEntityVO", description = "站点管理人员")
@Data
@TableName("tr_site_manage")
public class SiteManage extends Model<SiteManage> {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "站点ID")
	@TableField("site_id")
	private Long siteId;

	@ApiModelProperty(value = "人员ID")
	@TableField("account_id")
	private Long accountId;

	@ApiModelProperty(value = "0无效 1有效")
	private Integer state;

	@ApiModelProperty(value = "创建时间")
	@TableField("create_time")
	private Date createTime;

	@ApiModelProperty(value = "创建人ID")
	@TableField("create_by_id")
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	@TableField("create_by_name")
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	@TableField("update_time")
	private Date updateTime;

	@ApiModelProperty(value = "修改人ID")
	@TableField("update_by_id")
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	@TableField("update_by_name")
	private String updateByName;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
