package com.yizhi.site.application.mapper;

import java.util.List;
import java.util.Map;

import com.yizhi.site.application.domain.Information;
import org.apache.ibatis.annotations.Param;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.site.AnnouncementVO;
import com.yizhi.site.application.vo.site.InfomationParamVO;
import com.yizhi.site.application.vo.site.InformationStudentVO;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface InformationMapper extends BaseMapper<Information> {

    List<Information> informationFirstList(InfomationParamVO vo, Page<Information> page);

    List<Information> informationTwoList(InfomationParamVO vo, Page<Information> page);

    List<Information> informationAllList(InfomationParamVO vo, Page<Information> page);

    List<Information>  informationThreeList(InfomationParamVO vo, Page<Information> page);

    List<AnnouncementVO> selectAnnouncement(Page<AnnouncementVO> page, Map<String, Object> map);

    List<InformationStudentVO> informationPageList(@Param("typeName") String typeName, @Param("siteId") Long siteId, @Param("typeOne") Long typeOne, Page<InformationStudentVO> page);

    /**
     * 版本2  修改 ：去掉置顶排序
     */
    List<InformationStudentVO> informationPageListV2(@Param("typeName") String typeName, @Param("siteId") Long siteId, @Param("typeOne") Long typeOne, Page<InformationStudentVO> page);

    List<InformationStudentVO> informationPageOtherList(@Param("typeOne") Long typeOne, @Param("typeTwo") Long typeTwo, @Param("siteId") Long siteId, Page<InformationStudentVO> page);

    List<InformationStudentVO> selectInformationVO(@Param("typeOne") Long typeOne, @Param("siteId") Long siteId,
                                                   @Param("state") Integer state, Page<InformationStudentVO> page);

    List<Information> searchInformation(Page<Information> page, Information info);

    List<Information> searchInformation(Information info);

    /**
     * 查询新闻数量
     *
     * @param id
     * @return
     */

    Integer queryInformationByTypeTwo(@Param("id") Long id);


    /**
     * ---------------------分割线---------------
     */
    List<Information> getRelationAnnouncementPC(@Param("terminalId") Long terminalId);


    List<InformationStudentVO> informationPcPageList(@Param("typeName") String typeName, @Param("siteId") Long siteId, @Param("typeOne") Long typeOne, Page<InformationStudentVO> page);


    List<InformationStudentVO> informationClassifyPcPageList(@Param("typeName") String typeName, @Param("siteId") Long siteId, @Param("typeTwo") Long typeTwo, @Param("level") Integer level, Page<InformationStudentVO> page);


    Long informationRelationGetInformationIds(@Param("terminalId") Long terminalId);

    List<Long> getRelationInformationIds(@Param("templateId") Long templateId);


    String getType(@Param("id") Long id, @Param("siteId") Long siteId);

    /**
     * 获取相关的新闻id
     *
     * @param terminalId
     * @return
     */
    List<Long> selectRelationIds(@Param("terminalId") Long terminalId);

    /**
     * 获取置顶的公告
     */
    List<InformationStudentVO> informationTopList(@Param("typeName") String typeName, @Param("siteId") Long siteId,@Param("typeOne") Long typeOne);
    
    /**
     * 获取首页置顶新闻
     */
    List<InformationStudentVO> informationIndexTopList(@Param("siteId") Long siteId);
}