package com.yizhi.site.application.service;

import java.util.List;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.DataClassification;
import com.yizhi.site.application.vo.domain.DataClassificationVo;
import com.yizhi.site.application.vo.site.ClassificationVO;
import com.yizhi.site.application.vo.site.IdTwoVO;
import com.yizhi.site.application.vo.site.RespVO;
import com.yizhi.site.application.vo.site.SiteComponyIdVO;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface DataClassificationService extends IService<DataClassification> {
	/**
	 * 根据父级id查询子类
	 *
	 * @param parentId
	 * @return
	 */
	List<DataClassification> getSon(Long parentId);

	/**
	 * 获取分类资料列表
	 *
	 * @param siteId
	 * @return
	 */
	public List<ClassificationVO> getClassification(SiteComponyIdVO SiteComponyIdVO);

	/**
	 * 添加分类
	 *
	 * @param dataClassification
	 * @return
	 */
	Boolean insertClassification(DataClassification dataClassification);

	/**
	 * 查询所有的父类
	 *
	 * @return
	 */
	List<DataClassification> selectParent(RequestContext context);

	/**
	 * 分类拖动
	 * @param vo
	 * @return
	 */
	Boolean dragClassify(IdTwoVO vo);

    /**
     * 删除二级分类
     * @param id 二级分类的Id
     * @return
     */
	 RespVO delClassify(Long id);

	/**
	 * 获得所有新闻二级分类(没有内容的筛除)
	 * @param siteId
	 * @param typeOne
	 * @return
	 */
	List<DataClassification> getSubcategories(Long siteId, Long typeOne);

	/**
	 * 获取根节点下所有分类
	 * @param siteComponyIdVO
	 * @param parentId
	 * @return
	 */
	List<DataClassificationVo> getAllClassification(SiteComponyIdVO siteComponyIdVO, Long parentId);
}
