package com.yizhi.site.application.service;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.site.application.domain.SiteDic;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 门户字典表 服务类
 * </p>
 *
 * @author lingye
 * @since 2019-04-29
 */
public interface ISiteDicService extends IService<SiteDic> {
    /**
     * 根据code获取门户添加列表
     *
     * @param code
     * @return
     */
    List<SiteDic> getSiteDicListByCode(String code);

    /**
     * 站点字典修
     *
     * @param siteDic
     * @return
     */
    SiteDic updateDicById(SiteDic siteDic);

    /**
     * 查询字典
     * @param siteDic
     * @return
     */
    SiteDic selectSiteDic(SiteDic siteDic);


    /**
     * 获取字典map
     * @param siteDic
     * @return Map
     */
    Map<Long,SiteDic> selectSiteDicMap(SiteDic siteDic);
}
