package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.site.application.domain.FunctionDisplayConfig;
import com.yizhi.site.application.mapper.FunctionDisplayConfigMapper;
import com.yizhi.site.application.service.IFunctionDisplayConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 显示配置---》功能项显示配置 服务实现类
 * </p>
 *
 * @author 谢海军123
 * @since 2019-04-29
 */
@Service
public class FunctionDisplayConfigServiceImpl extends ServiceImpl<FunctionDisplayConfigMapper, FunctionDisplayConfig> implements IFunctionDisplayConfigService {

    private static final Logger logger= LoggerFactory.getLogger(FunctionDisplayConfigServiceImpl.class);

    @Override
    public List<FunctionDisplayConfig> findSiteAllConfig(Long siteId) {
        return this.baseMapper.findSiteAllConfig(siteId);
    }

    @Override
    public List<FunctionDisplayConfig> findSiteConfig(Long siteId) {
        List<FunctionDisplayConfig> dataList = new ArrayList<>();
        try(
                Connection conn = this.sqlSessionBatch().getConnection();
                Statement pst = conn.createStatement();
        ) {

            StringBuilder sql = new StringBuilder("");

            sql.append("SELECT id,function_name functionName,function_type functionType,use_device useDevice,")
                    .append(" use_device_type useDeviceType,show_display showDisplay FROM function_display_config")
                    .append(" WHERE site_id = ").append(siteId).append(" ORDER BY id");
            ResultSet rs = pst.executeQuery(sql.toString());
            while(rs.next()){
                FunctionDisplayConfig item = new FunctionDisplayConfig();
                item.setId(rs.getLong("id"));
                item.setFunctionName(rs.getString("functionName"));
                item.setFunctionType(rs.getString("functionType"));
                item.setUseDevice(rs.getString("useDevice"));
                item.setUseDeviceType(rs.getString("useDeviceType"));
                Integer showDisplay = rs.getInt("showDisplay");
                item.setShowDisplay((showDisplay==null || showDisplay.intValue()==0?false:true));
                dataList.add(item);
            }
            rs.close();
        } catch (SQLException e) {
            logger.info("执行sql异常{}",e);
        }

        return dataList;
    }
}
