package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.PageFooter;
import com.yizhi.site.application.domain.PageFooterItem;
import com.yizhi.site.application.domain.PageFooterItemConfig;
import com.yizhi.site.application.mapper.PageFooterItemConfigMapper;
import com.yizhi.site.application.mapper.PageFooterItemMapper;
import com.yizhi.site.application.mapper.PageFooterMapper;
import com.yizhi.site.application.mapper.PortalTerminalMapper;
import com.yizhi.site.application.internationlization.InternationalizationUtil;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.IPageFooterItemConfigService;
import com.yizhi.site.application.service.IPageFooterItemService;
import com.yizhi.site.application.vo.site.LinkVo;
import com.yizhi.site.application.vo.site.PageFooterItemConfigVo;
import com.yizhi.site.application.vo.site.PageFooterVO;
import com.yizhi.system.application.utils.ClassUtils;
import com.yizhi.system.application.vo.InternationalizationVo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liang123
 * @since 2018-12-21
 */
@Service
public class PageFooterItemServiceImpl extends ServiceImpl<PageFooterItemMapper, PageFooterItem> implements IPageFooterItemService {

    private Logger logger = LoggerFactory.getLogger(PageFooterItemServiceImpl.class);

    @Autowired
    private PageFooterItemConfigMapper pageFooterItemConfigMapper;

    @Autowired
    private PageFooterItemMapper pageFooterItemMapper;

    @Autowired
    private PageFooterMapper pageFooterMapper;

    @Autowired
    private IdGenerator idGenerator;

    @Autowired
    private PortalTerminalMapper terminalMapper;
    @Autowired
    private InternationalizationUtil internationalizationUtil;
    @Autowired
    private IPageFooterItemConfigService itemConfigService;

    /**
     * 删除
     *
     * @param
     * @return
     */
    @Override
    @Transactional
    public Boolean deleteByPageFooterItem(Long id) {


        PageFooterItem pageFooterItem = new PageFooterItem();
        pageFooterItem.setId(id);
        pageFooterItem = pageFooterItemMapper.selectOne(pageFooterItem);
        pageFooterItem.setDelete(1);
        if (pageFooterItemMapper.updateById(pageFooterItem) > 0) {
            //同时删除国际化对应记录
            InternationalizationVo a = new InternationalizationVo();
            a.setTableType(ClassUtils.getTableName(PageFooterItem.class));
            a.setTaskIds(new ArrayList<>());
            a.getTaskIds().add(id);
            //获取子链接的ids
            List<Long> ids = itemConfigService.getIds(id);
            a.getTaskIds().addAll(ids);
            internationalizationUtil.deletedInternationalization(a);
        }

        return true;
    }



//    /**
//     * 文案表单保存
//     *
//     * @param pageFooterItem
//     * @return
//     */
//    @Override
//    @Transactional
//    public PageFooterItemEntityVo save(PageFooterItemEntityVo pageFooterItem) {
//        RequestContext context = ContextHolder.get();
//        PageFooterEntityVo footer = new PageFooterEntityVo();
//        footer.setSiteId(context.getSiteId());
//        footer.setDelete(0);
//
//        PageFooterItemEntityVo footerItem = new PageFooterItemEntityVo();
//        PageFooterEntityVo pf = pageFooterMapper.selectOne(footer);
//        pf.setType(1);
//        pf.setUpdateById(context.getAccountId());
//        pf.setUpdateByName(context.getAccountName());
//        pf.setUpdateTime(new Date());
//        pageFooterMapper.updateById(pf);
//
//
//        footerItem.setId(idGenerator.generate());
//        footerItem.setPageFooterId(pf.getId());
//        footerItem.setOfficialDocumentContent(pageFooterItem.getOfficialDocumentContent());
//        footerItem.setType(pageFooterItem.getType());
//        footerItem.setDelete(0);
//        footerItem.setSiteId(context.getSiteId());
//        footerItem.setCompanyId(context.getCompanyId());
//        footerItem.setOrgId(context.getOrgId());
//        footerItem.setCreateTime(new Date());
//        footerItem.setCreateById(pageFooterItem.getCreateById());
//        footerItem.setCreateByName(pageFooterItem.getCreateByName());
//
//        // 保存排序
//        PageFooterItemEntityVo pageFooterItemEx = new PageFooterItemEntityVo();
//        pageFooterItemEx.setDelete(0);
//        pageFooterItemEx.setCompanyId(context.getCompanyId());
//        pageFooterItemEx.setSiteId(context.getSiteId());
//
//        EntityWrapper<PageFooterItemEntityVo> ew = new EntityWrapper<>(pageFooterItemEx);
//        ew.orderBy("sort", false);
//        PageFooterItemEntityVo lastBrother = pageFooterItemEx.selectOne(ew);
//        if (null != lastBrother) {
//            footerItem.setSort(lastBrother.getSort() + 1);
//        } else {
//            footerItem.setSort(1);
//        }
//        pageFooterItemMapper.insert(footerItem);
//
//        return pageFooterItem;
//    }


    /**
     * 根据 类型 查询列表(回显)
     *
     * @param TerminalType
     * @return
     */
    @Override
    public PageFooterVO getList(Integer TerminalType, Long companyId, Long orgId, Long siteId) {

        RequestContext context = ContextHolder.get();
        PageFooter footer = new PageFooter();
        footer.setSiteId(context.getSiteId());
        footer.setDelete(0);
        PageFooter pf = pageFooterMapper.selectOne(footer);

        List<PageFooterItemConfigVo> vos = new ArrayList<>();
        PageFooterVO footerVO = new PageFooterVO();

        List<PageFooterItem> pageFooterItems = null;
        if (pf == null){
            Long homeId = terminalMapper.geHomeIdByTerminalTypeAndSiteId(siteId,TerminalType );
            PageFooter footerCurrent = new PageFooter();
            footerCurrent.setId(idGenerator.generate());
            footerCurrent.setType(0);
            footerCurrent.setDelete(0);
            footerCurrent.setHomeId(homeId);
            footerCurrent.setSiteId(context.getSiteId());
            footerCurrent.setOrgId(context.getOrgId());
            footerCurrent.setCompanyId(context.getCompanyId());
            footerCurrent.setCreateById(context.getAccountId());
            footerCurrent.setCreateByName(context.getAccountName());
            footerCurrent.setCreateTime(new Date());
            pageFooterMapper.insert(footerCurrent);
            footerVO.setContent("上海易知科技提供技术支持");
            footerVO.setType(0);
        }else {
            pageFooterItems = pageFooterItemMapper.selectPageFooterItemList(pf.getId(), companyId, null, siteId);

                // 如果类型是使用默认页底
                    footerVO.setContent("上海易知科技提供技术支持");
                    footerVO.setType(pf.getType());
                    //获取国际化

            Map<Long, String> map = null;
            if (CollectionUtils.isNotEmpty(pageFooterItems)){
                if (StringUtils.isNotBlank(context.getLanguageType())) {
                    List<Long> taskIds = pageFooterItems.parallelStream().map(a -> a.getId()).collect(Collectors.toList());
                    map = internationalizationUtil.getMap(ClassUtils.getTableName(PageFooterItem.class), taskIds, context.getLanguageType());
                }
            }

            //类型是自定义页底
                    for (PageFooterItem footerItem : pageFooterItems) {
                        PageFooterItemConfigVo pageFooterItemConfigVo = new PageFooterItemConfigVo();

                        pageFooterItemConfigVo.setPageFooterId(footerItem.getPageFooterId());
                        pageFooterItemConfigVo.setPageFooterItemId(footerItem.getId());
                        pageFooterItemConfigVo.setSort(footerItem.getSort());
                        pageFooterItemConfigVo.setCreateTime(footerItem.getCreateTime());
                        if (footerItem.getPageType() != null){
                            // 如果类型是文案
                            if (footerItem.getPageType() == 0) {
                                pageFooterItemConfigVo.setContent(footerItem.getOfficialDocumentContent());
                                pageFooterItemConfigVo.setPageType(footerItem.getPageType());
                                if (map != null) {
                                    String word = map.get(footerItem.getId());
                                    if (StringUtils.isNotBlank(word)) {
                                        pageFooterItemConfigVo.setContent(word);
                                    }
                                }
                                //如果类型是链接
                            } else if (footerItem.getPageType() == 1) {
                                pageFooterItemConfigVo.setPageType(footerItem.getPageType());
                                if (footerItem.getShowable() == 1){
                                    pageFooterItemConfigVo.setName(footerItem.getName());
                                    if (map != null) {
                                        String word = map.get(footerItem.getId());
                                        if (StringUtils.isNotBlank(word)) {
                                            pageFooterItemConfigVo.setName(word);
                                        }
                                    }
                            }
                                pageFooterItemConfigVo.setShowable(footerItem.getShowable());
                                pageFooterItemConfigVo.setType(footerItem.getType());

                                List<PageFooterItemConfig> footerItemConfigs = pageFooterItemConfigMapper.selectPageFooterItemConfigList(footerItem.getId());

                                ArrayList<LinkVo> linkVos = new ArrayList<>();
                                //获取国际化
                                Map<Long, String> map1 = null;
                                if (StringUtils.isNotBlank(context.getLanguageType())) {
                                    List<Long> taskIds = footerItemConfigs.parallelStream().map(a -> a.getId()).collect(Collectors.toList());
                                    map1 = internationalizationUtil.getMap(ClassUtils.getTableName(PageFooterItemConfig.class), taskIds, context.getLanguageType());
                                }

                                for (PageFooterItemConfig footerItemConfig : footerItemConfigs) {
                                    LinkVo linkVo = new LinkVo();
                                    //  链接类型是文字链接
                                    if (footerItem.getType() == 0) {
                                        linkVo.setCharaterTag(footerItemConfig.getCharaterTag());
                                        linkVo.setLink(footerItemConfig.getLink());
                                        linkVo.setSort(footerItemConfig.getSort());
                                        if (map1!=null){
                                            String word = map1.get(footerItemConfig.getId());
                                            if (StringUtils.isNotBlank(word)){
                                                linkVo.setCharaterTag(word);
                                            }
                                        }
                                        linkVos.add(linkVo);
                                    } else if (footerItem.getType() == 1) {
                                        linkVo.setImgOssUrl(footerItemConfig.getImgOssUrl());
                                        linkVo.setLink(footerItemConfig.getLink());
                                        linkVo.setSort(footerItemConfig.getSort());
                                        linkVos.add(linkVo);
                                    }

                                }
                                pageFooterItemConfigVo.setLinkVos(linkVos);

                            }

                        }
                        vos.add(pageFooterItemConfigVo);
                        footerVO.setType(pf.getType());
                        footerVO.setPageFooterItemConfigVos(vos);
                    }
            }

        return footerVO;
    }


    /**
     * 排序(文案、链接)
     *
     * @param list
     * @return
     */
    @Override
    public Integer pageFooterItemSort(List<PageFooterItem> list) {
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                try {
                    pageFooterItemMapper.updateById(list.get(i));
                } catch (Exception e) {
                    logger.error("排序失败", e);
                    return 0;
                }
            }
        }
        return 1;
    }
}
