package com.yizhi.site.application.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.eum.DeletedEnum;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.domain.SystemMailbox;
import com.yizhi.site.application.mapper.MyItemConfigMapper;
import com.yizhi.site.application.mapper.SystemMailboxMapper;
import com.yizhi.site.application.service.SystemMailboxService;
import com.yizhi.site.application.vo.domain.SystemMailboxParamVo;
import com.yizhi.site.application.vo.domain.SystemMailboxVo;
import com.yizhi.site.application.vo.domain.SystemMailboxConditionVo;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.vo.AccountVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * com.yizhi.site.application.service.impl
 *
 * @author yanglang
 * @create 2025-01-09 13:58:12
 */
@Service
public class SystemMailboxServiceImpl extends ServiceImpl<SystemMailboxMapper,SystemMailbox> implements SystemMailboxService {

    @Autowired
    private IdGenerator idGenerator;

    @Autowired
    private MyItemConfigMapper myItemConfigmapper;

    @Autowired
    private AccountClient accountClient;

    @Override
    public Page<SystemMailbox> selectPage(SystemMailboxConditionVo conditionVo){
        Page<SystemMailbox> page = new Page<>(conditionVo.getPageNo(), conditionVo.getPageSize());
        EntityWrapper<SystemMailbox> entityWrapper = new EntityWrapper();
        RequestContext context = ContextHolder.get();
        entityWrapper.eq("site_id",context.getSiteId());
        entityWrapper.eq("deleted",0);
        if(ObjectUtil.isNotEmpty(conditionVo.getContactName())){
            entityWrapper.like("contact_name",conditionVo.getContactName());
        }
        if(ObjectUtil.isNotEmpty(conditionVo.getContactNumber())){
            entityWrapper.like("contact_number",conditionVo.getContactNumber());
        }
        if(ObjectUtil.isNotEmpty(conditionVo.getAnonymousFlag())){
            entityWrapper.eq("anonymous_flag",conditionVo.getAnonymousFlag());
        }
        if(ObjectUtil.isNotEmpty(conditionVo.getTargetFrom())){
            entityWrapper.eq("target_from",conditionVo.getTargetFrom());
        }
        if(ObjectUtil.isNotEmpty(conditionVo.getFileName())){
            entityWrapper.like("file_name",conditionVo.getFileName());
        }
        Long accountId = ContextHolder.get().getAccountId();
        List<Long> roleIds =  myItemConfigmapper.getJjXxRoleCount(accountId);
        if(CollectionUtil.isNotEmpty(roleIds)){
            if(roleIds.contains(1877604582759526400L)&&!roleIds.contains(1877605828904022016L)){
                conditionVo.setType(2);
            }
            if(!roleIds.contains(1877604582759526400L)&&roleIds.contains(1877605828904022016L)){
                conditionVo.setType(1);
            }
            if(!ContextHolder.get().isAdmin()&&!roleIds.contains(1877604582759526400L)&&!roleIds.contains(1877605828904022016L)){
                conditionVo.setCreateById(accountId);
            }
        }

        if(ObjectUtil.isNotEmpty(conditionVo.getType())){
            entityWrapper.eq("type",conditionVo.getType());
        }

        if(ObjectUtil.isNotEmpty(conditionVo.getCreateById())){
            entityWrapper.eq("create_by_id",conditionVo.getCreateById());
        }

        List<String> list = new ArrayList<String>();
        list.add("submitTime");
        entityWrapper.orderDesc(list);
        return this.selectPage(page,entityWrapper);
    }

    @Override
    public Long save(SystemMailboxVo systemMailBoxVo) {
        SystemMailbox systemMailBox = new SystemMailbox();
        RequestContext res = ContextHolder.get();
        systemMailBoxVo.setUpdateById(res.getAccountId());
        systemMailBoxVo.setUpdateByName(res.getAccountName());
        systemMailBoxVo.setUpdateTime(new Date());
        systemMailBox.setDeleted(DeletedEnum.NO.getValue());
        BeanUtils.copyProperties(systemMailBoxVo,systemMailBox);
        Long id = systemMailBox.getId();
        RequestContext context = ContextHolder.get();
        systemMailBox.setSiteId(context.getSiteId());
        if(id==null||id==0L) {
            id = idGenerator.generate();
            systemMailBox.setId(id);
            systemMailBox.setSubmitTime(new Date());
            systemMailBox.setState(SiteConstant.TWO);
            systemMailBox.setCreateById(res.getAccountId());
            systemMailBox.setCreateByName(res.getAccountName());
            systemMailBox.setCreateTime(new Date());
            AccountVO accountVO = accountClient.findById(res.getAccountId());
            if(StringUtils.isEmpty(systemMailBox.getContactName())){
                systemMailBox.setContactName(accountVO.getFullName());
            }
            if(StringUtils.isEmpty(systemMailBox.getContactNumber())){
                systemMailBox.setContactNumber(accountVO.getName());
            }
            this.insert(systemMailBox);
        }else{
            this.updateById(systemMailBox);
        }
        return id;
    }

    @Override
    public SystemMailboxVo getById(Long id) {
        SystemMailbox systemMailBox = this.selectById(id);
        if(systemMailBox==null){
            return null;
        }
        SystemMailboxVo systemMailBoxVo = new SystemMailboxVo();
        BeanUtils.copyProperties(systemMailBox,systemMailBoxVo);
        return systemMailBoxVo;
    }

    @Override
    public Boolean removeById(Long id) {
        return this.deleteById(id);
    }

    @Override
    public Page<SystemMailboxParamVo> selectMyPage(Integer pageNo,Integer pageSize, Integer type){
        pageNo = pageSize * (pageNo - 1);
        Long accountId = ContextHolder.get().getAccountId();
        List<Long> roleIds =  myItemConfigmapper.getJjXxRoleCount(accountId);
        Integer roleType = null;//信箱类型  1： 纪检   2: 书记,null没权限看 纪检和书记，只能看自己的
        if(CollectionUtil.isNotEmpty(roleIds)){
            if(roleIds.contains(1877604582759526400L)&&!roleIds.contains(1877605828904022016L)){
            	roleType = 2;
            }
            if(!roleIds.contains(1877604582759526400L)&&roleIds.contains(1877605828904022016L)){
            	roleType = 1;
            }
        }
        
        Page<SystemMailboxParamVo> page = new Page<>(pageNo,pageSize);
        page.setTotal(this.baseMapper.selectMyCount(accountId, roleType, type));
        page.setRecords(this.baseMapper.selectMyPage(accountId, roleType, type, pageNo, pageSize));
        return page;
    }
}
