package com.yizhi.site.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.domain.InformationVo;
import com.yizhi.site.application.vo.site.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 学员端-新闻资讯接口
 * @author mei
 *
 */
@FeignClient(name = "portal", contextId = "InformationStudentFeignClients")
public interface InformationStudentFeignClients {

	/**
	 * 获取新闻资讯列表
	 * @param
	 * @return
	 */
	@PostMapping("/api/info/page/list")
	public InformationListVO informationPageList(@RequestBody InfoVO infoVO);

	/**
	 * 获取新闻资讯banner
	 * @param infoVO
	 * @return
	 */
	@PostMapping("/api/info/mobile/bannerImages")
	public List<ImageListVO> listBannerImages(@RequestBody InfoVO infoVO);

	/**
	 *pc端,新闻/公告列表
	 *
	 * @param infoVO
	 * @return
	 */
	@PostMapping("/api/info/page/pcList")
	public InformationListPcVo informationPcPageList(@RequestBody InfoVO infoVO);

	/**
	 *pc端,新闻/公告列表
	 * 版本2  公告的查询修改
	 */
	@PostMapping("/api/info/page/v2/pcList")
	public InformationListPcVo informationPcPageListV2(@RequestBody InfoVO infoVO);

	/**
	 * pc端查看新闻资讯详情
	 *
	 * @param id
	 * @return
	 */
	@PostMapping("/api/info/pcView")
	public InformationViewVO getPcInformation(@RequestBody IdOneVO id);

	/**
	 * 获取新闻资讯列表
	 * @param
	 * @return
	 */
	@PostMapping("/api/info/list")
	public InformationListVO informationList(@RequestBody InfoVO infoVO);

	/**
	 * 查看新闻资讯详情
	 * @param
	 * @return
	 */
	@PostMapping("/api/info/view")
	public InformationViewVO getInformation(@RequestBody IdOneVO id);

	public

	/**
	 * 首页搜索新闻资讯
	 * @param id
	 * @return
	 */
	@PostMapping("/api/info/home/search")
	Page<InformationVo> searchInformation(@RequestBody InfomationParamVO vo);

}
