package com.yizhi.site.application.feign.api;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.domain.SystemMailboxConditionVo;
import com.yizhi.site.application.vo.domain.SystemMailboxParamVo;
import com.yizhi.site.application.vo.domain.SystemMailboxVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * com.yizhi.site.application.feign.api
 *
 * @author yanglang
 * @create 2025-01-09 14:27:21
 */
@FeignClient(name = "portal", contextId = "SystemMailboxClients")
public interface SystemMailboxClients {

    @PostMapping("/systemMailbox/selectPage")
    Page<SystemMailboxVo> selectPage(@RequestBody SystemMailboxConditionVo conditionVo);

    @PostMapping("/systemMailbox/save")
    Long save(@RequestBody SystemMailboxVo systemMailBoxVo);

    @GetMapping("/systemMailbox/getById")
    SystemMailboxVo getById(@RequestParam("id")Long id);

    @GetMapping("/systemMailbox/removeById")
    Boolean removeById(@RequestParam("id")Long id);

    @GetMapping("/systemMailbox/selectMyPage")
    Page<SystemMailboxParamVo> selectMyPage(@RequestParam("pageNo")Integer pageNo, @RequestParam("pageSize")Integer pageSize, @RequestParam("type")Integer type);
    
    @GetMapping("/systemMailbox/hasPermission")
    Boolean hasPermission();
    
    /**
     *
     * @return
     */
    @GetMapping("/systemMailbox/selectMailboxManagementForScroll")
    List<SystemMailboxParamVo> selectMailboxManagementForScroll();

    @GetMapping("/systemMailbox/selectMyPageNoView")
    Page<SystemMailboxParamVo> selectMyPageNoView(@RequestParam("pageNo")Integer pageNo, @RequestParam("pageSize")Integer pageSize, @RequestParam("type")Integer type);

}