package com.yizhi.site.application.vo.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * com.yizhi.site.application.vo.domain
 *
 * @author yanglang
 * @create 2025-01-09 13:52:53
 */
@Data
public class SystemMailboxVo {

        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "主鍵")
        private Long id;

        @ApiModelProperty(value = "信箱标题")
        private String fileName;

        @ApiModelProperty(value = "信箱类型  1： 纪检   2: 书记")
        private Integer type;

        @ApiModelProperty(value = "联系人名称")
        private String contactName;

        @ApiModelProperty(value = "联系人手机号/邮箱")
        private String contactNumber;

        @ApiModelProperty(value = "提交时间")
        private Date submitTime;

        @ApiModelProperty(value = "内容")
        private String content;

        private Integer anonymousFlag;

        private String targetFrom;

        @ApiModelProperty(value = "备注")
        private String  remark;

        @ApiModelProperty(value = "审核时间")
        private Date approveTime;

        @ApiModelProperty(value = "审批人")
        private Long approveById;

        @ApiModelProperty(value = "状态 0 删除 1 草稿 2 待审核 3 待发布 4 已发布 5 不通过")
        private Integer state;

        @ApiModelProperty(value = "站点ID")
        private Long siteId;

        @ApiModelProperty(value = "创建时间")
        private Date createTime;

        @ApiModelProperty(value = "创建人")
        private Long createById;

        @ApiModelProperty(value = "创建人姓名")
        private String createByName;

        @ApiModelProperty(value = "修改时间")
        private Date updateTime;

        @ApiModelProperty(value = "修改人")
        private Long updateById;

        @ApiModelProperty(value = "修改人姓名")
        private String updateByName;

        @ApiModelProperty(value = "图片链接地址")
        private String ossPicUrl;

        @ApiModelProperty(value = "视频链接地址")
        private String ossVideoUrl;

        @ApiModelProperty(value = "是否查看：0未查看，1已查看")
        private Integer isViewed;

        protected Serializable pkVal() {
            return this.id;
        }

}