package com.yizhi.site.application.vo.site;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value="ApiTemplateListVO", description="学员端模块列表")
@Data
public class ApiTemplateListVO {

	@ApiModelProperty(value = "模块ID")
    private Long id;

    @ApiModelProperty(value = "模块图片")
    private String imageUrl;
	
	@ApiModelProperty(value = "首页ID")
    private Long homeId;
    
    @ApiModelProperty(value = "站点ID")
    private Long siteId;
    
    @ApiModelProperty(value = "板块类型,1:推荐/精选,2:项目培训,3:课程,4:直播,5:新闻")
    private Integer moduleType;
    
    @ApiModelProperty(value = "图片")
    private String icon;
    
    @ApiModelProperty(value = "显示名称")
    private String moduleName;
    
    @ApiModelProperty(value = "选择项目, 推荐/精选 有,  直播 新闻 没有")
    private String selectProject;
    
    @ApiModelProperty(value = "内容个数")
    private Integer num;
    
    @ApiModelProperty(value = "精选专题")
    private List<ApiFeatureVO> featureList;
    
    @ApiModelProperty(value = "培训项目")
    private List<MyProjectAndCourseVO> projectList;
    
    @ApiModelProperty(value = "热门课程分类")
    private List<PopCourseListVO> popularCourseList;
    
    @ApiModelProperty(value = "课程")
    private List<MyProjectAndCourseVO> courseList;
    
    @ApiModelProperty(value = "新闻")
    private List<TemplateNewsVO> newsList;
    
    @ApiModelProperty(value = "直播")
    private List<MyProjectAndCourseVO> liveList;
    
//    @ApiModelProperty(value = "学员个人相关， 培训项目、课程")
//    private List<MyProjectAndCourseVO> myList;
}
