package com.yizhi.site.application.vo.site;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@ApiModel(value="BannerImageListVO", description="轮播图片 新增")
public class BannerImageListVO {
	
	@ApiModelProperty(value = "主键")
	private Long id;
	
	@ApiModelProperty(value = "图片标题")
	private String imgTitle;
	
	@ApiModelProperty(value = "存放图片路径")
	private String bannerPath;
	
	@ApiModelProperty(value = "banner名称，营销，首页，培训，课程，新闻资讯，专辑")
	private String bannerName;
	
	@ApiModelProperty(value = "跳转后的功能id")
	private String linkUrl;

	@ApiModelProperty(value = "首页类型, 1：课程  2：考试   3：培训  4：外部链接,  0 不是首页, 8:首页不选类型时候（仅仅图片），7专辑")
	private Integer homeType;
	
	@ApiModelProperty(value = "指定上架时间")
	private Date addTime;
	
	@ApiModelProperty(value = "站点ID")
	private Long siteId;

	@ApiModelProperty(value = "终端ID")
	private Long terminalId;
	
	@ApiModelProperty(value = "用户ID")
	private Long accountId;	
	
	@ApiModelProperty(value = "公司ID")
	private Long companyId;
	
	@ApiModelProperty(value = "部门ID")
	private Long orgId;
	
	@ApiModelProperty(value = "用户名称")
	private String accountName;

	@ApiModelProperty(value = "副标题")
	private String imgTitleSub;
	
	@ApiModelProperty(value = "图片来源")
	private String imgSource;
}
