package com.yizhi.site.application.vo.site;

import java.util.List;


import com.yizhi.site.application.vo.domain.InformationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@Api(tags = "InformationViewVO", description = "资讯信息")
public class InformationViewVO extends InformationVo {
	
	@ApiModelProperty(value = "阅读数")
    private Integer readCount;

    @ApiModelProperty(value = "当前信息前一条信息ID")
    private Long preInformationId;

    @ApiModelProperty(value = "当前信息前一条信息名字")
    private String preInformationName;

    @ApiModelProperty(value = "当前信息前一条信息索引")
    private Integer preListNO;

    @ApiModelProperty(value = "当前信息前一条信息原文链接")
    private String preUrl;

    @ApiModelProperty(value = "当前信息后一条信息ID")
    private Long suffixInformationId;

    @ApiModelProperty(value = "当前信息后一条信息名字")
    private String suffixInformationName;

    @ApiModelProperty(value = "当前信息前一条信息索引")
    private Integer suffixListNO;

    @ApiModelProperty(value = "收藏状态 0:取消收藏 1:已收藏")
    private Integer favoriteState;

    @ApiModelProperty(value = "当前信息后一条信息原文链接")
    private String suffixUrl;

    @ApiModelProperty(value = "新闻资讯类型")
    private String typeName;

    private List<PdfPagesVo> pdfPages;
}
