package com.yizhi.site.application.vo.site;

import java.util.Date;

import com.baomidou.mybatisplus.annotations.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
public class LiveActivityPc {
	
	@ApiModelProperty(value="终端iD")
	private Long terminalId;
	
	@ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "直播主题")
    private String title;

    @ApiModelProperty(value = "直播密码")
    private String password;

    @ApiModelProperty(value = "直播logo")
    @TableField("logo_image")
    private String logoImage;

    @ApiModelProperty(value = "主播名称")
    private String anchor;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "开始时间")
    @TableField("start_time")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "结束时间")
    @TableField("end_time")
    private Date endTime;

    @ApiModelProperty(value = "直播介绍")
    private String description;

    @ApiModelProperty(value = "可见范围 0 为站点 1 为可选范围")
    private Integer scope;

    @ApiModelProperty(value = "频道号")
    private String channel;

   

}
