package com.yizhi.site.application.vo.site;

import com.yizhi.site.application.vo.domain.ProtalPlateVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class TemplateInsertPcVO {


    /**
     * 新建模板逻辑    moduleType=1     传 id moduleType  num 必填  listPlate中的selectActivity（培训项目ID),linkContent(活动ID)  linkType(活动类型)
     * -- 外链
     * selectActivityName(外链的url)   imgPath(图片地址)
     * linkContentName(外链的名字)   selectActivity(外链的地址后端会自己生成)
     * moduleType=2     传 id moduleType  num 必填 listPlate中的                                                  linkContent（培训项目ID)
     * moduleType=3     传 id moduleType  num 必填 listPlate中的                                                  linkContent（课程ID)
     * moduleType=4     传 id moduleType  num 必填 listPlate中的                                                  linkContent（新闻ID)
     */

    @ApiModelProperty(value = "模板ID")
    private Long id;

    @ApiModelProperty(value = "板块类型,1:推荐/精选,2:项目培训,3:课程,4:直播,5:新闻,6.案例库，7.智能推荐")
    private Integer moduleType;

    @ApiModelProperty(value = "板块的名称")
    private String moduleName;

    @ApiModelProperty("精选活动数量")
    private Integer num = 0;

    @ApiModelProperty(value = "模板列表信息保存")
    private List<ProtalPlateVo> listPlate;

    @ApiModelProperty(value = "培训项目ID")
    private Long selectProject;


}
