package com.yizhi.site.application.controller;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.yizhi.site.application.domain.Information;
import com.yizhi.site.application.mapper.InformationClassifyMapper;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.service.PortalBannerService;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.comment.application.feign.PdfPagesClient;
import com.yizhi.comment.application.vo.PdfVO;
import com.yizhi.core.application.event.EventWrapper;
import com.yizhi.core.application.publish.CloudEventPublisher;
import com.yizhi.site.application.vo.domain.InformationVo;
import com.yizhi.site.application.vo.site.InfomationParamReleaseVO;
import com.yizhi.util.application.constant.TpActivityType;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.service.InformationService;
import com.yizhi.site.application.vo.domain.InformationClassify;
import com.yizhi.site.application.vo.site.IdOneVO;
import com.yizhi.site.application.vo.site.InfomationParamVO;
import com.yizhi.site.application.vo.site.ParamVO;

import io.swagger.annotations.Api;

/**
 * <p>
 * 资讯管理，前端控制器
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Api(tags = "管理端-资讯管理", description = "资讯管理")
@RestController
@RequestMapping("/manage/site/classify/info")
public class InformationManageController {
	@Autowired
	private InformationService informationService;

	@Autowired
    PortalBannerService portalBannerService;

    @Autowired
    private CloudEventPublisher cloudEventPublisher;

    @Autowired
    private PdfPagesClient pdfPagesClient;
    
    @Autowired
    private InformationClassifyMapper informationClassifyMapper;
    
    @Autowired
    private IdGenerator idGenerator;
    
    private static final Logger LOGGER = LoggerFactory.getLogger(InformationManageController.class);

	@PostMapping("/list")
	public Page<Information> list(@RequestBody InfomationParamVO vo) {
		return informationService.informationList(vo);
	}

	@ApiOperation(value = "查询发布的新闻列表")
	@PostMapping("/release/list")
	public Page<Information> releaseList(@RequestBody InfomationParamReleaseVO vo) {
		return informationService.informationReleaseList(vo);
	}

	@PostMapping("/insert")
	public Long insert(@RequestBody Information information) {
		return informationService.insertInformation(information);
	}

	@PostMapping("/update")
	public Boolean update(@RequestBody Information information) {

        try {
            // 删除任务
            portalBannerService.delete(information.getId());
        } catch (Exception e) {
            e.printStackTrace();
        }

        // 判断时间
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        //输入新闻的发布时间
        Calendar releaseTime = Calendar.getInstance();
        releaseTime.setTime(information.getReleaseTime());
        if (releaseTime.after(date)){
            informationService.updateById(information);
            information.setState(SiteConstant.FIRST);
            try {
                // 添加定时上架
                informationService.timeUpInfomation(information.getId());
            } catch (Exception e) {
                e.printStackTrace();
            }

        } else {
            information.setState(SiteConstant.TWO);
            informationService.updateById(information);
        }
        
        //保存资讯分类
        if (!CollectionUtils.isEmpty(information.getInformationClassify())) {
        	for(InformationClassify item : information.getInformationClassify()){
        		if(item.getId() == null || item.getId() == 0){
        			item.setId(idGenerator.generate());
        			item.setInformationId(information.getId());
            		item.setCreateById(information.getCreateById());
            		item.setCreateByName(information.getCreateByName());
            		item.setCreateTime(information.getCreateTime());
            		item.setUpdateById(information.getUpdateById());
            		item.setUpdateByName(information.getUpdateByName());
            		item.setUpdateTime(information.getUpdateTime());
            		
            		informationClassifyMapper.insert(item);
        		}
        	}

        	//删除不存在的资讯分类
        	//获取已有的资讯
        	InformationClassify classify = new InformationClassify();
            classify.setInformationId(information.getId());
            EntityWrapper<InformationClassify> wrapper = new EntityWrapper<InformationClassify>(classify);
            List<InformationClassify> informationClassify = informationClassifyMapper.selectList(wrapper);
            if (!CollectionUtils.isEmpty(informationClassify)) {
            	boolean isDel = true;
            	for(InformationClassify old : informationClassify){
            		isDel = true;
            		for(InformationClassify item : information.getInformationClassify()){
            			if(old.getId().equals(item.getId())){
            				isDel = false;
            				break;
            			}
            		}
            		if(isDel){
            			informationClassifyMapper.deleteById(old.getId());
            		}
            	}
            }
        } else {
        	//删除所有资讯分类
        	InformationClassify classify = new InformationClassify();
            classify.setInformationId(information.getId());
            EntityWrapper<InformationClassify> wrapper = new EntityWrapper<InformationClassify>(classify);
            List<InformationClassify> informationClassify = informationClassifyMapper.selectList(wrapper);
            if (!CollectionUtils.isEmpty(informationClassify)) {
            	for(InformationClassify old : informationClassify){
            		informationClassifyMapper.deleteById(old.getId());
            	}
            }
        }
        
        if (!StringUtils.isEmpty(information.getPdfOssUrl()) && !StringUtils.isEmpty(information.getPdfFileName())) {
            List<PdfVO> pdfVOs = new ArrayList<PdfVO>();
            PdfVO pdfVO = new PdfVO();
            pdfVO.setBizId(information.getId());
            pdfVO.setBizType(TpActivityType.TYPE_INFORMATION);
            pdfVO.setSiteId(information.getSiteId());
            pdfVO.setCreateById(information.getCreateById());
            pdfVO.setOriginalFile(information.getPdfFileName());
            pdfVO.setOriginalFileUrl(information.getPdfOssUrl());
            pdfVOs.add(pdfVO);
    		try {
    			if (!CollectionUtils.isEmpty(pdfVOs)) {
    				LOGGER.info("pdf解析图片发送消息："+pdfVOs.toString());
    				cloudEventPublisher.publish("pdfToPng",
    						new EventWrapper(0L, pdfVOs));
    			}
    		} catch (Exception e) {
    			// TODO Auto-generated catch block
    			e.printStackTrace();
    			LOGGER.error("pdf解析图片发送消息失败：",e);
    		}
        }


        return true;
	}

	@PostMapping("/delete")
	public boolean deleteById(@RequestBody IdOneVO vo) {
		return informationService.deleteById(vo.getId());
	}

	@PostMapping("/releases")
	public boolean releases(@RequestBody ParamVO vo) {
		return informationService.releases(vo);
	}

	@PostMapping("/unreleases")
	public boolean unreleases(@RequestBody ParamVO vo) {
		return informationService.unreleases(vo);
	}

	@GetMapping("/view/{id}")
	public Information informationView(@RequestParam(name = "id") Long id) {
		return informationService.informationView(id);
	}
	
	@GetMapping(value = "/listbyName")
	public List<Information> listbyName(@RequestParam(name = "name")String name, @RequestParam(name = "siteId")Long siteId){
		return informationService.listbyName(name, siteId);
	}
	
	@PostMapping("/top")
	public Boolean top(@RequestBody IdOneVO vo){
		return informationService.top(vo.getId());
	}

    /**
     * 新闻资讯公告上架
     * @param id 新闻公告id
     * @return
     */
    @GetMapping(value = "/upInfomation")
    public boolean upInfomation(@RequestParam(value = "id") Long id) {
        return informationService.releaseInfomation(id);
    }


    @PostMapping(value = "/timeUp")
    public boolean upState(@RequestParam(value = "id") Long id){
        try {
            // 添加定时上架
            informationService.timeUpInfomation(id);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    /**
     * 新闻资讯pdf转图片需要
     * @return
     */
    @PostMapping(value = "/updateContent")
    public boolean updateContent(@RequestBody Information information) {
        if (information.getId() == null) {
            LOGGER.error("异常处理新闻pdf转图片，id为空！");
            return false;
        }
      return this.informationService.updateById(information);
    }


	@GetMapping(value = "/listbyIds")
	public List<InformationVo> listbyIds(@RequestParam(name = "idList")List<Long> idList){
		return this.informationService.listbyIds(idList);

	}
}
