package com.yizhi.site.application.controller;


import java.util.Date;
import java.util.List;

import com.yizhi.site.application.mapper.PortalNavigateMapper;
import com.yizhi.site.application.mapper.PortalTerminalMapper;
import com.yizhi.site.application.service.HomeAnnouncementService;
import com.yizhi.site.application.service.HomeImageService;
import com.yizhi.site.application.service.HomeLogoService;
import com.yizhi.site.application.domain.PortalTemplate;
import com.yizhi.site.application.domain.Information;
import com.yizhi.site.application.vo.domain.ProtalPlateVo;
import com.yizhi.site.application.vo.site.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.site.application.domain.PortalNavigate;
import com.yizhi.site.application.domain.ProtalPlate;
import com.yizhi.site.application.domain.RelationLink;
import com.yizhi.site.application.domain.RelationLive;
import com.yizhi.site.application.domain.TrPortalLookNum;
import com.yizhi.site.application.domain.TrPortalPage;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.IRelationLinkService;
import com.yizhi.site.application.service.IRelationLiveService;
import com.yizhi.site.application.service.ITrPortalLookNumService;
import com.yizhi.site.application.service.ITrPortalPageBottomService;
import com.yizhi.site.application.service.ITrPortalPageService;
import com.yizhi.site.application.service.InformationService;
import com.yizhi.site.application.service.PortalBannerService;
import com.yizhi.site.application.service.PortalNavigateService;
import com.yizhi.site.application.service.PortalTemplateService;
import com.yizhi.site.application.service.PortalTerminalService;
import com.yizhi.site.application.service.ProtalPlateService;

/**
 * 
 * @author wangfeida
 *
 */
@RestController
@RequestMapping("/manage/portal/pc")
public class PortalManagePCController {
	
	
	
	
	
	
	/**
	 * 验证代码提交
	 * @param id3
	 * @return
	 */
	
	@Autowired
	private PortalNavigateMapper portalNavigateMapper;
	
	@Autowired
	private IdGenerator idGenerator;
	
	
	@RequestMapping("/test/myself")
	List<PortalNavigate> testMyself(){
		
		// 这两个sql可手工执行。
		//UPDATE tr_portal_navigate SET sort=sort+3 WHERE  state=1 AND pc_type=1;
		//INSERT INTO relation_link(id,CODE,NAME,url,state) VALUE(19,19,'首页',NULL,1),(20,20,'我的学习',NULL,1),(21,21,'排行榜',NULL,1);
		
		
		//发布的东西
		Date curDate=new Date();
		List<PortalNavigate> list=portalNavigateMapper.selectListInit();
		if(CollectionUtils.isNotEmpty(list)) {
			for (PortalNavigate portalNavigate : list) {
				Long homeId=portalNavigate.getHomeId();
				Long siteId=portalNavigate.getSiteId();
				Long createById=portalNavigate.getCreateById();
				String createByName=portalNavigate.getCreateByName();
				PortalNavigate p=new PortalNavigate();
				p.setId(idGenerator.generate());
				p.setHomeId(homeId);
				p.setSiteId(siteId);
				
				p.setRelationFunc(0);
				p.setDisplay(1);
				p.setCreateTime(curDate);
				p.setCreateById(createById);
				p.setCreateByName(createByName);
				p.setState(1);
				
				
				p.setId(idGenerator.generate());
				p.setShowName("首页");
				p.setRelationFuncName("首页");
				p.setSort(1);
				p.setRelationFuncCode("19");
				portalNavigateMapper.insert(p);
				
				p.setId(idGenerator.generate());
				p.setShowName("课程");
				p.setRelationFuncName("课程");
				p.setSort(2);
				p.setRelationFuncCode("20");
				portalNavigateMapper.insert(p);
				
				
				p.setId(idGenerator.generate());
				p.setShowName("我的学习");
				p.setRelationFuncName("我的学习");
				p.setSort(3);
				p.setRelationFuncCode("21");
				portalNavigateMapper.insert(p);
				
			}
		}
		return null;
		
		
	}
	
	@Autowired
	private PortalTerminalMapper portalTerminalMapper;
	
	@Autowired
	private PortalTerminalService portalTerminalService;
	
	@Autowired
	private HomeLogoService homeLogoService;
	
	@Autowired
	private IRelationLinkService relationLinkService ;
	
	@Autowired
	private PortalNavigateService portalNavigateService;
	
	@Autowired
	private HomeImageService homeImageService;
	@Autowired
	private PortalBannerService portalBannerService;
	
	@Autowired
	private IRelationLiveService relationLiveService;
	
	@Autowired
	private InformationService informationService;
	@Autowired
	private HomeAnnouncementService homeAnnouncementService;
	
	@Autowired
	private PortalTemplateService portalTemplateService;
	
	@Autowired
	private ProtalPlateService protalPlateService;
	
	@Autowired
	private ITrPortalPageService trPortalPageService;
	
	@Autowired
	private ITrPortalPageBottomService trPortalPageBottomService;
	
	@Autowired
	private ITrPortalLookNumService trPortalLookNumService;
	

	

	
	

	
	/**
	 * 首页logo新增
	 * @param vo
	 * @return
	 */
	@GetMapping("/home/logo/insert")
	public HomeLogoVO insertHomeLogoPc(@RequestParam(value="terminalId",required=true)Long terminalId, @RequestParam(value="logoPath",required=true)String logoPath) {
		return homeLogoService.insertHomeLogoPc(terminalId,logoPath);
	}
	
	
	
	@GetMapping("/home/logo/delete")
	public Boolean deletetHomeLogoPc(@RequestParam(value="logoId",required=true)Long logoId) {
		return homeLogoService.deleteHomeLogoPc(logoId);
	}
	
	
	/**
	 * 首页logo修改
	 * @param vo
	 * @return
	 */
	@GetMapping("/home/logo/update")
	public HomeLogoVO updateHmeLogoPc(@RequestParam("logoId")Long logoId,@RequestParam("newLogoPath")String newLogoPath) {
		return homeLogoService.updateHmeLogoPc(logoId,newLogoPath);
	}
	
	/**
	 * 首页logo查看
	 * @param homeId
	 * @return
	 */
	@GetMapping("/home/logo/view")
	public HomeLogoVO viewHomeLogoPc(@RequestParam("terminalId")Long terminalId) {
		return homeLogoService.viewHomeLogoPc(terminalId);
	}
	
	
	
	/**
	 * 得到所有的链接
	 * @return
	 */
	@GetMapping("/home/alllistLink")
	public List<RelationLink> getAllListLink(@RequestParam(value="name",required=false)String name, @RequestParam(value="type",required=true)Integer type){
		return relationLinkService.getAllListLink(name,type);
	}
	
	
	
	@PostMapping("/home/navigate/update")
	public PortalNavigate updateAndInsertNavigatePc(@RequestBody NavigateListVO vo) {
		return portalNavigateService.updateAndInsertNavigatePc(vo);
	}
	
	
	@GetMapping("/home/navigate/select")
	public List<PortalNavigate> getRelationListLink(@RequestParam(name = "terminalId", required = true) Long terminalId,@RequestParam(name = "pcType", required = true) Integer pcType){
		return portalNavigateService.getRelationListLink(terminalId, pcType);
	}
	
	
	
	@GetMapping("/home/navigate/delete")
	public Boolean deleteNavigatePc(@RequestParam(name = "id", required = true) Long id) {
		return portalNavigateService.deleteNavigatePc(id);
	}
	
	
	@GetMapping("/home/navigate/update/sort")
	public Boolean updateSortNavigatePc(@RequestParam(name = "id", required = true) Long id,@RequestParam(name = "isDown", required = true) Integer isDown) {
		return portalNavigateService.updateSortNavigatePc(id, isDown);
	}
	
	@GetMapping("/home/look/num/select")
    TrPortalLookNum lookNumSelectPc(@RequestParam(name = "terminalId", required = true) Long terminalId) {
	   return trPortalLookNumService.lookNumSelectPc(terminalId);
	}
	
	@GetMapping("/home/look/num/set")
	TrPortalLookNum lookNumSetPc(@RequestBody TrPortalLookNum trPortalLookNum) {
	   return trPortalLookNumService.lookNumSetPc(trPortalLookNum);
	}
	
	
	@GetMapping("/home/banner/select")
	public List<PreviewImageVO> getRelationBanerPc(@RequestParam(name = "terminalId", required = true) Long terminalId){
		return homeImageService.getRelationBanerPc(terminalId);
	}
	
	
	@GetMapping("/home/banner/all")
	public Page<ImageListVO> getAllBanerPc(
			@RequestParam(name = "terminalId", required = true) Long terminalId,
			@RequestParam("pageNo")Integer pageNo,
            @RequestParam("pageSize")Integer pageSize){
		return portalBannerService.getAllBanerPc(terminalId, pageNo, pageSize);
	}
	
	@GetMapping("/banner/insert")
	Boolean insertBanerPc( @RequestParam(name = "terminalId", required = true) Long terminalId,
            @RequestParam(name = "ids", required = true) List<Long> ids) {
		return homeImageService.insertBanerPc(terminalId, ids);
	}
	
	
	@GetMapping("/home/banner/delete")
	Boolean deleteRelationBanerPc(
			@RequestParam(name = "terminalId") Long terminalId,
			@RequestParam(name="id")Long id) {
		return homeImageService.deleteRelationBanerPc(terminalId,id);
	}
	
	
	@GetMapping("/home/banner/update/sort")
	Boolean updateBannerSortPC(@RequestParam(name = "terminalId", required = true) Long terminalId,@RequestParam(name = "currentId", required = true) Long currentId,@RequestParam(name = "isDown", required = true) Integer isDown) {
		return homeImageService.updateBannerSortPC(terminalId, currentId, isDown);
	}
	
	
	@GetMapping("/live/relation")
	List<Long> getRelationLivePc(@RequestParam(name = "terminalId", required = true) Long terminalId){
		return relationLiveService.getRelationLivePc(terminalId);
	}
	
	
	@GetMapping("/home/live/save")
    RelationLive saveRelationLive(@RequestParam(name = "terminalId", required = true) Long terminalId, @RequestParam(name = "liveId", required = true) Long liveId) {
		return relationLiveService.saveRelationLive(terminalId, liveId);
	}
	
	
	@GetMapping("/home/live/delete")
	Boolean deleteRelationLive(@RequestParam(name = "terminalId", required = true) Long terminalId,@RequestParam(name = "liveId", required = true) Long liveId) {
		return relationLiveService.deleteRelationLive(terminalId, liveId);
	}
	
	
	

	
	@GetMapping("/navigate/update/display")
	Boolean navigateUpdateDisplay(@RequestParam(name = "terminalId", required = true) Long terminalId,@RequestParam(name = "display", required = true) Integer display) {
		return portalNavigateService.navigateUpdateDisplay(terminalId, display);
	}
	
	@GetMapping("/navigate/view/display")
	Integer navigateViewDisplay(@RequestParam(name = "terminalId", required = true) Long terminalId) {
		return portalNavigateService.navigateViewDisplay(terminalId);
	}
	
	@GetMapping("/announcement/all")
	Page<Information> getAllAnnouncementPC(
			@RequestParam(name = "terminalId", required = true) Long terminalId,
			@RequestParam(name = "pageNo", required = false,defaultValue="1") Integer pageNo,
			@RequestParam(name = "pageSize", required = false,defaultValue="10") Integer pageSize){
		return informationService.getAllAnnouncementPC(terminalId,pageNo, pageSize);
	}
	
	@GetMapping("/announcement/select")
	List<Information> getRelationAnnouncement(@RequestParam(name = "terminalId", required = true) Long terminalId){
		return informationService.getRelationAnnouncementPC(terminalId);
	}
	
	
	@PostMapping("/announcement/insert/update")
	Boolean insertUpdateRelationAnnouncementPC(@RequestBody AnnouncementVO announcementVO) {
		return homeAnnouncementService.insertUpdateRelationAnnouncementPC(announcementVO);
	}
	
	
	@GetMapping("/announcement/view/display")
	Integer announcementViewDisplay(@RequestParam(name = "terminalId", required = true) Long terminalId) {
		return homeAnnouncementService.announcementViewDisplay(terminalId);
	}
	
	
	@GetMapping("/announcement/details/update")
	Boolean updateDetailsAnnouncementPC(@RequestParam(name = "terminalId", required = true) Long terminalId,
			@RequestParam(name = "currentId", required = true) Long currentId,
			@RequestParam(name = "isDown", required = true) Integer isDow) {
		return homeAnnouncementService.updateDetailsAnnouncementPC(terminalId, currentId, isDow);
	}
	
	
	@GetMapping("/module/list/select")
	List<PortalTemplate> moduleListSelect(@RequestParam(name = "terminalId", required = true) Long terminalId){
		return portalTemplateService.moduleListSelect(terminalId);
	}
	
	
	@GetMapping("/module/name/add")
	PortalTemplate moduleNameAdd(@RequestParam(name = "terminalId", required = true) Long terminalId,@RequestParam(name = "currentId", required = false) Long currentId,@RequestParam(name = "isDown", required = true) Integer isDown,@RequestParam(name = "moduleType", required = true) Integer moduleType,@RequestParam(name = "moduleName", required = true) String moduleName) {
		return portalTemplateService.moduleNameAdd(terminalId,currentId,isDown, moduleType, moduleName);
	}
	
	@GetMapping("/module/update/message")
	Boolean moduleUpdateMessage(@RequestParam(name = "id", required = true) Long id,@RequestParam(name = "name", required = false) String name,@RequestParam(name = "state", required = false) Integer state,@RequestParam(name = "display", required = false) Integer display,@RequestParam(name = "isDown", required = false) Integer isDown) {
		return portalTemplateService.moduleUpdateMessage(id, name, state,display,isDown);
	}
	
	
/*	@GetMapping("/module/update/sort")
	Boolean moduleUpdateSort(@RequestParam(name = "sourceId", required = true) Long sourceId,@RequestParam(name = "targetId", required = true) Long targetId) {
		return portalTemplateService.moduleUpdateSort(sourceId, targetId);
	}*/
	
	@PostMapping("/template/content/add")
	Boolean templateContentAdd(@RequestBody TemplateInsertPcVO templateInsertPcVO) {
		return protalPlateService.templateContentAdd(templateInsertPcVO);
	}
	
	@GetMapping("/template/content/view")
	List<ProtalPlate> templateContentView(@RequestParam(name = "id", required = true) Long id){
		return protalPlateService.templateContentViewApi(id);
	}
	
	
	@GetMapping("/template/content/view/byterminalId/and/moduleType")
	List<Long> templateContentViewByTerminalIdAndModuleType(@RequestParam(name = "terminalId", required = true) Long terminalId,@RequestParam(name = "moduleType", required = true) Integer moduleType){
		return protalPlateService.templateContentViewByTerminalIdAndModuleType(terminalId, moduleType);
	}
	
	@GetMapping("/template/content/update")
	Boolean templateContentUpdate(@RequestParam(name = "id", required = true) Long id,@RequestParam(name = "activityId", required = true) Long activityId,@RequestParam(name = "state", required = false) Integer state,@RequestParam(name = "imgUrl", required = false) String imgUrl){
		return protalPlateService.templateContentUpdate(id, activityId, state, imgUrl);
	}

    /**
     * 修改模块
     * @param plateVO
     * @return
     */
    @PostMapping("/plate/update")
    Boolean updatePlate(@RequestBody PlateVO plateVO){
        return protalPlateService.updatePlate(plateVO);
    }

	/**
	 * 修改模块并回调
	 * @param plateVO
	 * @return
	 */
	@PostMapping("/plate/back/update")
	public ProtalPlateVo updateBackPlate(@RequestBody PlateVO plateVO){
		return protalPlateService.updateBackPlate(plateVO);
	}

    /**
     * 获取模块列表
     * @param protalPlate
     * @return
     */
    @GetMapping("/plate/get")
    public ProtalPlate getPlate(@RequestBody ProtalPlate protalPlate){
        return protalPlateService.getPlate(protalPlate);
    }
	@PostMapping("/plate/get")
	public ProtalPlate getPlateBy(@RequestBody ProtalPlate protalPlate){
		return protalPlateService.getPlate(protalPlate);
	}
	@GetMapping("template/content/select/content/view")
    PortalTemplateTraining templateContentSelectContentView(@RequestParam(name = "id", required = true) Long id) {
		return portalTemplateService.templateContentSelectContentView(id);
	}
	
	
	@GetMapping("/news/get/all")
	Page<Information> newsGetAll(@RequestParam(value="terminalId",required=true)Long terminalId,@RequestParam("pageNo")Integer pageNo,@RequestParam("pageSize")Integer pageSize){
		return informationService.getAllNewsPC(terminalId,pageNo, pageSize);
	}
	
	@GetMapping("/news/get/relation")
	List<Information> getRelationInformation(@RequestParam(name = "id", required = true) Long id){
		return informationService.getRelationInformation(id);
	}
	
	@PostMapping("/page/save/message")
	Boolean pageBottomSave(@RequestBody TrPortalPagePCVo trPortalPagePCVo) {
		return trPortalPageService.pageBottomSave(trPortalPagePCVo);
	}
	
	@GetMapping("/page/bottom/view")
	TrPortalPage pageBottomView(@RequestParam(name = "terminalId", required = true) Long terminalId) {
		return trPortalPageService.getTrPortalPageByTerminald(terminalId);
	}
	
	
	@GetMapping("/page/bottom/update")
	Boolean pageBottomUpdate(@RequestParam(name = "pageId", required = true) Long pageId,@RequestParam(name = "type", required = true) Integer type) {
		return trPortalPageService.pageBottomUpdate(pageId, type);
	}
	
	@GetMapping("/page/bottom/delete")
	Boolean pageBottomDelete(@RequestParam(name = "id", required = true) Long id) {
		return trPortalPageBottomService.pageBottomDelete(id);
	}
	
	@GetMapping("/page/bottom/update/sort")
	Boolean pageBottomUpdateSort(@RequestParam(name = "id", required = true) Long id,@RequestParam(name = "isDown", required = true) Integer isDown) {
		return trPortalPageBottomService.pageBottomUpdateSort(id, isDown);
	}
	
	
	@GetMapping("/site/url")
	ProtalPlate getUrl(@RequestParam(name="selectActivityId",required=true)Long selectActivityId) {
		return protalPlateService.getUrl(selectActivityId);
	}

    /**
     * 获取模块的关联的内容
     * @param ids
     * @return
     */
    @PostMapping(value = "/get/plate/list")
    public List<ProtalPlate> getPlateListById(@RequestBody List<Long> ids){
        return protalPlateService.getPlateListById(ids);
    }


    @GetMapping("/relation/live/list")
    List<RelationLive> getRelationLive(@RequestParam(name = "siteId", required = true) Long siteId,
                                       @RequestParam(name = "liveId", required = true) Long liveId) {
        return relationLiveService.getRelationLiveList(siteId,liveId);
    }
}

