package com.yizhi.site.application.controller.api;

import com.yizhi.site.application.service.EventTrackService;
import com.yizhi.site.application.vo.domain.EventTrackVo;
import com.yizhi.site.application.vo.site.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * com.yizhi.site.application.controller.api
 *
 * @author yanglang
 * @create 2025-01-14 10:57:55
 */
@RestController
public class EventTrackController {

    @Autowired
    private EventTrackService eventTrackService;


    @GetMapping("/api/eventTrack/addEvent")
    public void addEvent(@RequestParam("type") String type, @RequestParam("businessId") Long businessId) {
        eventTrackService.addEvent(type, businessId);
    }


    @GetMapping("/api/eventTrack/getTodayNum")
    public EventTrackDayNumVo getTodayNum(@RequestParam(value = "date", required = false) String date, @RequestParam(value = "types", required = false) Integer types) {
        return eventTrackService.getTodayNum(date);
    }

    @GetMapping("/api/eventTrack/getNumByType")
    public DayNumVo getNumByType(@RequestParam(value = "date", required = false) String date, @RequestParam("types") List<Integer> types) {
        return eventTrackService.getNumByType(date, types);
    }

    @GetMapping("/api/eventTrack/queryNumByType")
    public List<EventTrackTypeNumVo> queryNumByType(@RequestParam(value = "date", required = false) String date, @RequestParam("types") List<Integer> types
            , @RequestParam(value = "subName", required = false) String subName) {
        return eventTrackService.queryNumByType(date, types, subName);
    }

    @GetMapping("/api/eventTrack/queryDeptByType")
    public List<EventTrackDeptNumVo> queryDeptByType(@RequestParam(value = "date", required = false) String date, @RequestParam("types") List<Integer> types) {
        return eventTrackService.queryDeptByType(date, types);
    }

    @GetMapping("/api/eventTrack/queryTgNumByDept")
    public List<EventTrackDeptNumVo> queryTgNumByDept(@RequestParam(value = "typeId", required = false)Long typeId){
        return eventTrackService.queryTgNumByDept(typeId);
    }

    @GetMapping("/api/eventTrack/queryListByType")
    public List<EventTrackVo> queryListByType(@RequestParam("type") Integer type, @RequestParam("accountId") Long accountId){
        return eventTrackService.queryListByType(type,accountId);
    }

    @GetMapping("/api/eventTrack/getExamTotal")
    public Integer getExamTotal(@RequestParam("subType") String subType,@RequestParam("year") String year){
        return eventTrackService.getExamTotal(subType,year);
    }

    @GetMapping("/api/eventTrack/queryExamNum")
    public List<EventTrackDeptNumVo> queryExamNum(){
        return eventTrackService.queryExamNum();
    }

    @GetMapping("/api/eventTrack/queryRankList")
    public List<EventTrackRankListVo> queryRankList(@RequestParam("date") String date,@RequestParam("type") String type){
        return eventTrackService.queryRankList(date, type);
    }
}
