package com.yizhi.site.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.site.application.domain.SystemMailbox;
import com.yizhi.site.application.vo.domain.SystemMailboxParamVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * com.yizhi.site.application.mapper
 *
 * @author yanglang
 * @create 2025-01-09 13:55:24
 */
public interface SystemMailboxMapper extends BaseMapper<SystemMailbox> {

  List<SystemMailboxParamVo> selectMyPage(@Param("accountId") Long accountId, @Param("roleType") Integer roleType, @Param("type") Integer type, @Param("pageNo") Integer pageNo,@Param("pageSize") Integer pageSize);

  int selectMyCount(@Param("accountId") Long accountId, @Param("roleType") Integer roleType, @Param("type") Integer type);
  
  /**
   * 滚动提示接口：信箱管理（4天内创建且未查看的数据）
   * @param siteId
   * @return
   */
  List<SystemMailboxParamVo> selectMailboxManagementForScroll(@Param("accountId") Long accountId, @Param("roleType") Integer roleType);

  List<SystemMailboxParamVo> selectMyPageNoView(@Param("accountId") Long accountId, @Param("roleType") Integer roleType, @Param("type") Integer type, @Param("pageNo") Integer pageNo,@Param("pageSize") Integer pageSize);

  int selectMyCountNoView(@Param("accountId") Long accountId, @Param("roleType") Integer roleType, @Param("type") Integer type);

}
