package com.yizhi.site.application.service;

import java.util.List;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.site.application.domain.PortalTemplate;
import com.yizhi.site.application.vo.site.ApiTemplateMiddlerVO;
import com.yizhi.site.application.vo.site.PortalTemplateTraining;
import com.yizhi.site.application.vo.site.TemplateListVO;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
public interface PortalTemplateService extends IService<PortalTemplate> {

	List<TemplateListVO> templateList(Long homeId);
	
	List<ApiTemplateMiddlerVO> templateApiList(Long homeId);

	boolean copyTemplate(Long sourceId, Long targetId);
	
	
	
	/**
	 * -------------------------分隔符-----------
	 */
	
	List<PortalTemplate> moduleListSelect(Long terminalId);
	
	PortalTemplate moduleNameAdd(Long terminalId,Long currentId,Integer isDown,Integer moduleType,String moduleName);

	Boolean moduleUpdateMessage(Long id,String name,Integer state,Integer display,Integer isDown);
	
	Boolean moduleUpdateSort(Long sourceId, Long targetId);
	
	PortalTemplateTraining templateContentSelectContentView(Long id);
	
	List<PortalTemplate> moduleListSelectApi(Long siteId,Integer terminalType);

    /**
     * 获取模块列表
     * @param terminalId
     * @date 2019年3月4日
     * @return
     */
    List<PortalTemplate> getManageModuleList(Long terminalId);


    /**
     * 模块移动
     *
     * @param sourceId
     * @param targetId
     * @return
     */
    Boolean sortTemplate(Long sourceId, Long targetId);

    /**
     * 上下移动
     * @param sourceId
     * @param type
     * @return
     */
    Boolean sortTemplate(Long sourceId, Integer type);

    /**
     * 获取template
     * @param id
     * @return
     */
    PortalTemplate getTemplateById(Long id);
}
