package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.yizhi.site.application.domain.HomeImage;
import com.yizhi.site.application.domain.PortalBanner;
import com.yizhi.site.application.domain.PortalImage;
import com.yizhi.site.application.mapper.HomeImageMapper;
import com.yizhi.site.application.service.HomeImageService;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.constant.SiteEnum;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.service.PortalBannerService;
import com.yizhi.site.application.service.PortalHomeService;
import com.yizhi.site.application.service.PortalImageService;
import com.yizhi.site.application.vo.site.PreviewImageVO;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Service
@Transactional
@Log4j2
public class HomeImageServiceImpl extends ServiceImpl<HomeImageMapper, HomeImage> implements HomeImageService {

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private PortalImageService portalImageService;
    @Autowired
    private PortalBannerService portalBannerService;

    @Autowired
    private PortalHomeService portalHomeService;

    @Autowired
    private HomeImageMapper homeImageMapper;

    private static Logger logger = LoggerFactory.getLogger(HomeImageServiceImpl.class);

    @Override
    public List<PreviewImageVO> imageList(Long homeId) {
        List<PreviewImageVO> imageList = new ArrayList<PreviewImageVO>();
        List<HomeImage> selectByMap = getHomeImages(ContextHolder.get().getSiteId(), homeId);
        log.info("list的长度：" + selectByMap.size());
        //组装vo
        buildPreviewImageVO(selectByMap, homeId, imageList,true);
        return imageList;
    }

    @Override
    public boolean copyHomeImage(Long sourceId, Long targetId) {
        List<HomeImage> list = new ArrayList<HomeImage>();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("home_id", sourceId);
        map.put("state", SiteConstant.FIRST);
        List<HomeImage> selectByMap = this.selectByMap(map);
        HomeImage p = null;
        for (HomeImage pi : selectByMap) {
            p = new HomeImage();
            BeanUtils.copyProperties(pi, p);
            p.setId(idGenerator.generate());
            p.setHomeId(targetId);
            list.add(p);
        }
        if (list.size() > 0) {
            this.insertBatch(list);
        }
        return true;
    }

    /**
     * 轮播图的拖拽
     *
     * @param homeId
     * @param sourceSort
     * @param targetSort
     * @return
     */
    @Override
    public List<HomeImage> getHomeImageList(Long homeId, Integer sourceSort, Integer targetSort) {
        HomeImage homeImage = new HomeImage();
        homeImage.setHomeId(homeId);
        homeImage.setState(SiteConstant.FIRST);
        EntityWrapper<HomeImage> wrapper = QueryUtil.condition(homeImage);
        if (targetSort < sourceSort) {
            wrapper.where("sort <= {0}", sourceSort).andNew("sort >= {0}", targetSort);
        } else {
            wrapper.where("sort <=  {0}", targetSort).andNew("sort >= {0}", sourceSort);
        }
        wrapper.orderBy("sort", true);
        List<HomeImage> list = this.selectList(wrapper);

        return list;
    }

    /**
     * 分隔符
     */
    @Override
    public List<PreviewImageVO> getRelationBanerPc(Long terminalId) {
        // TODO Auto-generated method stub
        List<PreviewImageVO> imageList = new ArrayList<PreviewImageVO>();
        /**
         * 通过终端ID得到homeId
         */
        Long homeId = portalHomeService.getHomeId(terminalId);
        if (homeId != null) {
            List<HomeImage> selectList = getHomeImages(ContextHolder.get().getSiteId(), homeId);
            //组装vo
            buildPreviewImageVO(selectList, homeId, imageList,false);
        }
        return imageList;

    }

    @Override
    public Boolean deleteRelationBanerPc(Long terminalId, Long id) {
        // TODO Auto-generated method stub
        HomeImage entity = new HomeImage();
        Long homeId = portalHomeService.getHomeId(terminalId);
        entity.setHomeId(homeId);
        entity.setImageId(id);
        EntityWrapper<HomeImage> wrapper = new EntityWrapper<HomeImage>(entity);
        HomeImage homeImage = new HomeImage();
        homeImage.setState(0);
        return this.update(homeImage, wrapper);
    }

    @Override
    public Boolean insertBanerPc(Long terminalId, List<Long> ids) {
        // TODO Auto-generated method stub
        Long homeId = portalHomeService.getHomeId(terminalId);
        //通过终端id找到最大的banner的sort

        if (homeId != null) {
            Integer maxsort = homeImageMapper.maxSortByTerminalId(homeId);
            if (maxsort == null) {
                maxsort = 1;
            } else {
                maxsort++;
            }

            HomeImage homeImage = null;
            Date date = new Date();
            if (CollectionUtils.isNotEmpty(ids)) {
                for (int i = 0; i < ids.size(); i++) {
                    maxsort = maxsort + i;
                    homeImage = new HomeImage();
                    homeImage.setId(idGenerator.generate());
                    homeImage.setHomeId(homeId);
                    homeImage.setSiteId(ContextHolder.get().getSiteId());
                    homeImage.setImageId(ids.get(i));
                    homeImage.setState(1);
                    homeImage.setCreateById(ContextHolder.get().getAccountId());
                    homeImage.setCreateByName(ContextHolder.get().getAccountName());
                    homeImage.setCreateTime(date);
                    homeImage.setSort(maxsort);
                    this.insert(homeImage);
                }
            }
        }
        return true;
    }

    @Override
    public Boolean updateBannerSortPC(Long terminalId, Long currentId, Integer isDown) {
        // TODO Auto-generated method stub
        Long homeId = portalHomeService.getHomeId(terminalId);
        Long homeImageCurrentId = homeImageMapper.updateSortByTerminalId(homeId, currentId);
        HomeImage homeImageCurrent = this.selectById(homeImageCurrentId);
        Integer homeImageCurrentSort = homeImageCurrent.getSort();
        Long homeImageNextId = homeImageMapper.nextHomeImageBySort(homeId, homeImageCurrentSort, isDown);

        if (homeImageNextId == null) {
            return true;
        } else {
            HomeImage homeImageNext = this.selectById(homeImageCurrentId);
            Integer homeImageNextSort = homeImageNext.getSort();
            if (homeImageNextSort != null) {
                HomeImage homeImage1 = new HomeImage();
                homeImage1.setId(homeImageCurrentId);
                homeImage1.setSort(homeImageNextSort);
                this.updateById(homeImage1);

                HomeImage homeImage2 = new HomeImage();
                homeImage2.setId(homeImageNextId);
                homeImage2.setSort(homeImageCurrentSort);
                this.updateById(homeImage2);

                return true;
            }
        }
        return null;
    }

    /**
     * 获取轮播图的方法
     *
     * @return
     */
    @Override
    public List<PreviewImageVO> getRotationImages(Long homeId) {
        Long siteId = ContextHolder.get().getSiteId();
        List<PreviewImageVO> imageList = new ArrayList<PreviewImageVO>();
        List<HomeImage> homeImageList = getHomeImages(siteId, homeId);
        log.info("list的长度：" + homeImageList.size());
        //组装vo
        buildPreviewImageVO(homeImageList, homeId, imageList,false);
        return imageList;
    }

    /**
     * 获取数据
     *
     * @param siteId
     * @param homeId
     * @return
     */
    private List<HomeImage> getHomeImages(Long siteId, Long homeId) {
        HomeImage homeImage = new HomeImage();
        homeImage.setSiteId(siteId);
        homeImage.setHomeId(homeId);
        homeImage.setState(SiteConstant.FIRST);
        EntityWrapper<HomeImage> wrapper = QueryUtil.condition(homeImage);
        wrapper.orderBy("sort", true);
        return this.selectList(wrapper);
    }

    /**
     * 统一获取类型
     *
     * @param homeId
     * @param imageList
     */
    private void buildPreviewImageVO(List<HomeImage> homeImages, Long homeId, List<PreviewImageVO> imageList,Boolean isWechat) {
        if (CollectionUtils.isEmpty(homeImages)) {
            log.info("获取数据为空，直接返回！！");
            return;
        }
        PreviewImageVO previewImageVO = null;
        for (HomeImage tb : homeImages) {
            Long imageId = tb.getImageId();
            PortalImage portalImage = portalImageService.selectById(imageId);
            log.info("返回PortalImage实体：" + portalImage);
            if (portalImage == null || portalImage.getState() != 1) {
                continue;
            }
            previewImageVO = new PreviewImageVO();
            BeanUtils.copyProperties(portalImage, previewImageVO, "createTime", "createById", "createByName", "updateTime", "updateById", "updateByName");
            previewImageVO.setHomeId(homeId);
            previewImageVO.setPortImageId(tb.getId());
            previewImageVO.setSort(tb.getSort());
            previewImageVO.setKind(SiteEnum.DETAIL.getValue());
            log.info("返回的实体portalImage字段：" + tb.getId());
            Integer homeType = portalImage.getHomeType();
            //获取相应业务类型
            getType(homeType, portalImage.getBannerId(), previewImageVO,isWechat);
            imageList.add(previewImageVO);
        }
        if (CollectionUtils.isNotEmpty(imageList)) {
            imageList.sort((i1, i2) -> i1.getSort().compareTo(i2.getSort()));
        }
    }

    /**
     * 获取类型
     *  @param homeType
     * @param bannerId
     * @param previewImageVO
     * @param isWechat
     */
    private void getType(Integer homeType, Long bannerId, PreviewImageVO previewImageVO, Boolean isWechat) {
        //首页的类型, 1：课程  2：考试   3：培训  4：外部链接 5:新闻 6:调研 7:专辑  8：外链  0:不是首页
        if (homeType != null) {
            switch (homeType) {
                case 0:
                    PortalBanner selectById = portalBannerService.selectById(bannerId);
                    if (selectById != null) {
                        if (StringUtils.isNotBlank(selectById.getBannerName())) {
                            previewImageVO.setType(SiteEnum.getValueByKey(selectById.getBannerName()));
                        }
                    }
                    break;
                case 1:
                    previewImageVO.setType(SiteEnum.COURSE.getValue());
                    previewImageVO.setCatname(SiteEnum.COURSE.getKey());
                    break;
                case 2:
                    previewImageVO.setType(SiteEnum.EXAM.getValue());
                    previewImageVO.setCatname(SiteEnum.EXAM.getKey());
                    break;
                case 3:
                    previewImageVO.setType(SiteEnum.TRAIN.getValue());
                    previewImageVO.setCatname(SiteEnum.TRAIN.getKey());
                    break;
                case 4:
                    previewImageVO.setType(SiteEnum.OUTERCHAIN.getValue());
                    previewImageVO.setCatname(SiteEnum.OUTERCHAIN.getKey());
                    break;
                case 5:
                    previewImageVO.setType(SiteEnum.NEWS.getValue());
                    previewImageVO.setCatname(SiteEnum.NEWS.getKey());
                    break;
                case 6:
                    previewImageVO.setType(SiteEnum.MARKET.getValue());
                    previewImageVO.setCatname(SiteEnum.MARKET.getKey());
                    break;
                case 7:
                    previewImageVO.setType(isWechat?SiteEnum.ALBUM_DETAIL.getValue():SiteEnum.ALBUM.getValue());
                    previewImageVO.setCatname(isWechat?SiteEnum.ALBUM_DETAIL.getValue():SiteEnum.ALBUM.getValue());
                    break;
                case 8:
                    previewImageVO.setType(SiteEnum.OUTERCHAIN.getValue());
                    previewImageVO.setCatname(SiteEnum.OUTERCHAIN.getKey());
                    break;
                case 9:
                    break;
            }
        } else {
            previewImageVO.setType(SiteEnum.NULL.getValue());
            previewImageVO.setCatname(SiteEnum.NULL.getKey());
        }
    }
}
