package com.yizhi.site.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.point.application.vo.domain.PointVo;
import com.yizhi.site.application.controller.api.PortalBlockController;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.site.application.constant.SiteEnum;
import com.yizhi.point.application.feign.PointFeignClients;
import com.yizhi.site.application.internationlization.InternationalizationUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.*;
import com.yizhi.site.application.mapper.*;
import com.yizhi.site.application.service.*;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.site.application.enums.BlockTypeCode;
import com.yizhi.site.application.enums.PortalEnum;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.enums.ModuleType;
import com.yizhi.system.application.enums.TerminalType;
import com.yizhi.system.application.utils.ClassUtils;
import com.yizhi.system.application.vo.InternationalizationVo;
import com.yizhi.system.application.vo.domain.Internationalization;
import com.yizhi.wechat.application.vo.wechat.Constants;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Service
@Transactional
@Log4j2
public class PortalTerminalServiceImpl extends ServiceImpl<PortalTerminalMapper, PortalTerminal> implements PortalTerminalService {

	@Autowired
	private IdGenerator idGenerator;
	@Autowired
	private PortalTerminalMapper portalTerminalMapper;
	@Autowired
	private PortalBannerMapper portalBannerMapper;
	@Autowired
	private HomeImageMapper homeImageMapper;
	@Autowired
	private PortalNavigateMapper portalNavigateMapper;
	@Autowired
	private InformationMapper informationMapper;
	@Autowired
	private HomeAnnouncementMapper homeAnnouncementMapper;
	@Autowired
	private PortalTemplateMapper portalTemplateMapper;
	@Autowired
	private ProtalPlateMapper protalPlateMapper;
	@Autowired
	private PortalHomeService portalHomeService;
    @Autowired
    private PortalLoginService portalLoginService;
    @Autowired
	private PortalNavigateService portalNavigateService;
    @Autowired
	private HomeImageService homeImageService;
	@Autowired
	private PortalImageService portalImageService;
	@Autowired
	private PortalTemplateService portalTemplateService;
	@Autowired
	private ProtalPlateService protalPlateService;
	@Autowired
	private ProtalContactService protalContactService;
	@Autowired
	private HomeLogoService homeLogoService;
	@Autowired
	private HomeAnnouncementService homeAnnouncementService;
	@Autowired
	private TemplateCourseService templateCourseService;
	@Autowired
	private PortalBannerService portalBannerService;
	@Autowired
	private PortalTerminalService portalTerminalService;
	@Autowired
    ITrPortalBlockService portalBlockService;

	@Autowired
	private PointFeignClients pointFeignClients;

	@Autowired
	private InternationalizationUtil internationalizationUtil;
	 
	@Transactional
    @Override
	public List<TerminalListVO> listPortal(SiteComponyIdVO siteComponyIdVO) {
		Long companyId = siteComponyIdVO.getCompanyId();
		Long orgId = siteComponyIdVO.getOrgId();
		Long siteId = siteComponyIdVO.getSiteId();
		Long createById = siteComponyIdVO.getCreateById();
		String createByName = siteComponyIdVO.getCreateByName();


		//防止并发添加数据
		List<TerminalListVO> listPortal = portalTerminalMapper.listPortal(siteId, companyId);
		if(listPortal == null || listPortal.size()<1) {
			synchronized (this) {
				listPortal = portalTerminalMapper.listPortal(siteId, companyId);
				if(listPortal == null || listPortal.size()<1) {
					//创建站点积分配置
                	createSitePoint(siteId, companyId, createById, createByName, orgId);
                	
					Date date = new Date();
					Long pcId = portalBannerService.createTerminal("PC", siteId, companyId, createById, createByName, date, orgId, SiteConstant.TERMINAL_TYPE_PC, SiteConstant.SHOW);
					createPortalHome(pcId, createById, createByName, date,1,siteComponyIdVO);
					if(pcId != null){
						portalBannerService.createBanner(pcId, siteId, createById, createByName, date);
					}
//					Long appId = portalBannerService.createTerminal("APP", siteId, companyId, createById, createByName, date, orgId, SiteConstant.TERMINAL_TYPE_APP, SiteConstant.HIDE);
//					createPortalHome(appId, createById, createByName, date,2,siteComponyIdVO);
//					if(appId != null){
//						portalBannerService.createBanner(appId, siteId, createById, createByName, date);
//					}
					Long weChatId = portalBannerService.createTerminal("移动端", siteId, companyId, createById, createByName, date, orgId, SiteConstant.TERMINAL_TYPE_WEIXIN, SiteConstant.SHOW);
					createPortalHome(weChatId, createById, createByName, date,3,siteComponyIdVO);
					if(weChatId != null){
						portalBannerService.createBanner(weChatId, siteId, createById, createByName, date);
					}

					listPortal = portalTerminalMapper.listPortal(siteId, companyId);
				}
			}
		}

		return listPortal;
	}

	public void createPortalHome(Long terminalId, Long createById, String createByName, Date date, Integer terminalType, SiteComponyIdVO siteComponyIdVO) {
		PortalHome ph = new PortalHome();
		Long homeId = idGenerator.generate();
		ph.setId(homeId);
		ph.setTerminalId(terminalId);
		ph.setState(SiteConstant.FIRST);
		ph.setCreateById(createById);
		ph.setCreateByName(createByName);
		ph.setCreateTime(date);
		if (portalHomeService.insert(ph)) {
			if (terminalType == 3) {
				createMyTaskTemplate(homeId, siteComponyIdVO);
			}
		}
	}
	public void createMyTaskTemplate(Long homeId, SiteComponyIdVO siteComponyIdVO) {
		PortalTemplate template = new PortalTemplate();
		template.setId(idGenerator.generate());
		template.setHomeId(homeId);
		template.setCreateById(siteComponyIdVO.getCreateById());
		template.setCreateByName(siteComponyIdVO.getCreateByName());
		template.setCreateTime(new Date());
		template.setSiteId(siteComponyIdVO.getSiteId());
		template.setModuleName(SiteConstant.TODAYTASK);
		// 今日任务moduleType默认为0
		template.setModuleType(SiteConstant.ZERO);
		template.setState(SiteConstant.ZERO);
		template.setDisplay(SiteConstant.FIRST);
		portalTemplateService.insert(template);
	}
	@Override
	public Long releasePortal(Long terminalId) {
		releaseOrUnReleasePortal(terminalId, SiteConstant.FIRST);
		return terminalId;
	}

	@Override
	public Long unReleasePortal(Long terminalId) {
		releaseOrUnReleasePortal(terminalId, SiteConstant.ZERO);
		return terminalId;
	}

	public boolean releaseOrUnReleasePortal(Long terminalId, Integer state) {
		RequestContext context = ContextHolder.get();
		PortalTerminal terminal = this.selectById(terminalId);
		terminal.setState(state);
		terminal.setUpdateTime(new Date());
		terminal.setUpdateById(context.getAccountId());
		terminal.setUpdateByName(context.getAccountName());
		return this.updateById(terminal);
	}

	@Override
	public PortalPreviewVO previewPortal(Long terminalId) {
	    log.info("==================我是分分割线==========================");

		PortalPreviewVO vo = new PortalPreviewVO();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("terminal_id", terminalId);
		map.put("state", SiteConstant.FIRST);
		List<PortalHome> selectByMap = portalHomeService.selectByMap(map);
		if(selectByMap.size() == 0){
			map.put("state", SiteConstant.TWO);
			selectByMap = portalHomeService.selectByMap(map);
		}
		if(selectByMap.size() == 0 || selectByMap == null){
			return null;
		}
		PortalHome ph = selectByMap.get(0);
		//首页logo
		HomeLogoVO homeLogo = homeLogoService.homeLogoList(ph.getId());

		//导航栏列表
		List<NavigateListVO> navigateList = portalNavigateService.navigateList(ph.getId(), 0);

		//轮播图列表
		List<PreviewImageVO> imageList = homeImageService.imageList(ph.getId());

		//公告列表
		List<AnnouncementVO> announcementList = homeAnnouncementMapper.listAnnouncement(ph.getId());

		//模板列表
		List<TemplateListVO> templateList = portalTemplateService.templateList(ph.getId());

		//联系我们列表
		List<PreviewContactVO> contactList = protalContactService.contactList(ph.getId());
		vo.setHomeLogoVO(homeLogo);
		vo.setNavigateList(navigateList);
		vo.setAnnouncementList(announcementList);
		vo.setImageList(imageList);
		vo.setTemplateList(templateList);
		vo.setContactList(contactList);
		vo.setHomeId(ph.getId());
		return vo;
	}

	public Long homeRelease(IdOneVO vo){
		Long homeId = vo.getId();
		RequestContext context = vo.getContext();
		PortalHome selectById = portalHomeService.selectById(homeId);
		if(selectById.getState().equals(SiteConstant.FIRST)){
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("terminal_id", selectById.getTerminalId());
			map.put("state", SiteConstant.TWO);
			portalHomeService.deleteByMap(map);
			selectById.setState(SiteConstant.TWO);
			selectById.setUpdateById(context.getAccountId());
			selectById.setUpdateByName(context.getAccountName());
			selectById.setUpdateTime(new Date());
			portalHomeService.updateById(selectById);
		}
		return homeId;
	}


	/////   0: 删除  1: 未发布  2: 发布
	@Override
	public PortalLogin loginPageView(Long terminalId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("terminal_id", terminalId);
		map.put("state", SiteConstant.FIRST);
		List<PortalLogin> selectByMap = portalLoginService.selectByMap(map);
		if(selectByMap.size() == 0){
			map.put("state", SiteConstant.TWO);
			selectByMap = portalLoginService.selectByMap(map);
		}
		if(selectByMap.size() > 0){
			return selectByMap.get(0);
		}
		return null;
	}

	@Override
	public Long loginPageInsert(PortalLoginListVO vo) {
		RequestContext requestContext = vo.getContext();
		deleteLogin(vo.getTerminalId(), SiteConstant.FIRST);
		PortalLogin pl = new PortalLogin();
		pl.setId(idGenerator.generate());
		pl.setSiteId(vo.getSiteId());
		pl.setTerminalId(vo.getTerminalId());
		pl.setBgimgPath(vo.getBgimgPath());
		pl.setState(SiteConstant.FIRST);
		pl.setCreateById(requestContext.getAccountId());
		pl.setCreateByName(requestContext.getAccountName());
		pl.setCreateTime(new Date());
		pl.setUpdateById(requestContext.getAccountId());
		pl.setUpdateByName(requestContext.getAccountName());
		pl.setUpdateTime(new Date());
		portalLoginService.insert(pl);
		return pl.getId();
	}

	@Override
	public Long loginPageUpdate(PortalLogin pl) {
		String accountName = pl.getCreateByName();
		Long accountId = pl.getCreateById();
		Date date = pl.getCreateTime();
		Long terminalId = pl.getTerminalId();
		Long siteId = pl.getSiteId();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("terminal_id", terminalId);
		map.put("site_id", siteId);
		List<PortalLogin> selectByMap = portalLoginService.selectByMap(map);
		if(selectByMap == null || selectByMap.size() == 0){   //新增
			pl.setId(idGenerator.generate());
			pl.setState(SiteConstant.FIRST);
			portalLoginService.insert(pl);
			return pl.getId();
		}else{
			map.put("state", 1);
			List<PortalLogin> selectByMap2 = portalLoginService.selectByMap(map);
			if(selectByMap2 != null && selectByMap2.size() > 0){
				PortalLogin pp = selectByMap2.get(0);
				String bgimgPath = pl.getBgimgPath();
				if(bgimgPath != null && !StringUtils.equals(bgimgPath,"N")){
					pp.setBgimgPath(bgimgPath);
				}

				String loginNameDesc = pl.getLoginNameDesc();
				if(loginNameDesc != null && !StringUtils.equals(loginNameDesc,"N")){
					pp.setLoginNameDesc(loginNameDesc);
				}

				String loginPwdDesc = pl.getLoginPwdDesc();
				if(loginPwdDesc != null && !StringUtils.equals(loginPwdDesc,"N")){
					pp.setLoginPwdDesc(loginPwdDesc);
				}
				pp.setUpdateById(accountId);
				pp.setUpdateByName(accountName);
				pp.setUpdateTime(date);
				portalLoginService.updateById(pp);
				return pp.getId();
			}
			map.put("state", 2);
			List<PortalLogin> selectByMap3 = portalLoginService.selectByMap(map);
			if(selectByMap3 != null && selectByMap3.size() > 0){
				PortalLogin pp = selectByMap3.get(0);
				PortalLogin portalLogin = new PortalLogin();
				BeanUtils.copyProperties(pp, portalLogin);
				portalLogin.setId(idGenerator.generate());
				portalLogin.setBgimgPath(pl.getBgimgPath());
				portalLogin.setState(SiteConstant.FIRST);
				portalLoginService.insert(portalLogin);
				return portalLogin.getId();
			}
			return null;
		}
	}

	@Override
	public Long loginPageRelease(PortalLogin pl) {
		Long accountId = pl.getCreateById();
		String accountName = pl.getCreateByName();
		Date date = pl.getCreateTime();
		Long id = pl.getId();
		if(id == null){
			id = idGenerator.generate();
			pl.setId(id);
			pl.setState(SiteConstant.TWO);
			deleteLogin(pl.getTerminalId(), SiteConstant.FIRST);
			deleteLogin(pl.getTerminalId(), SiteConstant.TWO);
			portalLoginService.insert(pl);
		}else{
			PortalLogin pp = portalLoginService.selectById(id);
			if(pp.getState() == SiteConstant.FIRST){
				pp.setState(SiteConstant.TWO);
				pp.setBgimgPath(pl.getBgimgPath());
				pp.setUpdateById(accountId);
				pp.setUpdateByName(accountName);
				pp.setUpdateTime(date);
				deleteLogin(pl.getTerminalId(), SiteConstant.TWO);
				portalLoginService.updateById(pp);
			}else if(pp.getState() == SiteConstant.TWO){
				pp.setBgimgPath(pl.getBgimgPath());
				pp.setUpdateById(accountId);
				pp.setUpdateByName(accountName);
				pp.setUpdateTime(date);
				portalLoginService.updateById(pp);
			}
		}
		return id;
	}
	
	public boolean deleteLogin(Long terminalId, Integer state){
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("terminal_id", terminalId);
		map.put("state", state);
		portalLoginService.deleteByMap(map);
		return true;
	}
	
	@Override
	public HeadNavigateListVO listNavigate(PageParamVO vo) {
		HeadNavigateListVO nvo = new HeadNavigateListVO();
		Page<NavigateListVO> page = new Page<NavigateListVO>(vo.getPageNo(), vo.getPageSize());
		List<NavigateListVO> list = portalNavigateMapper.listNavigate(page, vo.getId());
		page.setRecords(list);
		nvo.setPage(page);
		nvo.setHomeId(vo.getId());
		PortalHome selectById = portalHomeService.selectById(vo.getId());
		if(selectById != null){
			Long terminalId = selectById.getTerminalId();
			if(terminalId != null){
				PortalTerminal selectById2 = portalTerminalService.selectById(terminalId);
				if(selectById2 != null){
					nvo.setSiteId(selectById2.getSiteId());
				}
			}
		}
		return nvo;
	}
	
	@Override
	public Boolean updateNavigate(NavigateListVO vo) {
	    log.info("传来的参数"+vo);
	    RequestContext context = ContextHolder.get();
        log.info("站点id："+context.getSiteId());
		Long accontId = context.getAccountId();
		String accountName = context.getAccountName();
		copyHome(vo.getHomeId(), accontId, accountName);
		
		if(vo.getId() == null){
			Integer sort = portalNavigateMapper.selectMaxSort(vo.getHomeId(), context.getSiteId());
			if(sort == null){
				sort = SiteConstant.FIRST;
			}else{
				sort += SiteConstant.FIRST;
			}
			PortalNavigate pn = new PortalNavigate();
			Long idGenera = idGenerator.generate();
			pn.setId(idGenera);
			pn.setHomeId(vo.getHomeId());
			pn.setSiteId(context.getSiteId());
			pn.setShowName(vo.getShowName());
			pn.setImgPath(vo.getImgPath());
			pn.setSort(sort);
			pn.setRelationFunc(vo.getRelationFunc());
			pn.setRelationFuncCode(vo.getRelationFuncCode());
			pn.setRelationFuncName(vo.getRelationFuncName());
			pn.setRelationFuncUrl(vo.getRelationFuncUrl());
			pn.setDisplay(vo.getDisplay());
			pn.setState(SiteConstant.FIRST);
			pn.setCreateById(context.getAccountId());
			pn.setCreateByName(context.getAccountName());
			pn.setCreateTime(new Date());
			pn.setRelationId(vo.getRelationId());
			// add lingye @2019-12-4
			pn.setRelationNum(vo.getRelationNum()!=null?vo.getRelationNum():"0");
			if (portalNavigateService.insert(pn)){
				//同时添加国际化记录
				Internationalization a = new Internationalization();
				a.setName(vo.getShowName());
				a.setModuleName(ModuleType.PORTAL.getName());
				a.setModuleType(ModuleType.PORTAL.getCode());
				a.setTableType(ClassUtils.getTableName(PortalNavigate.class));
				a.setTaskId(idGenera);
				a.setTerminalType(TerminalType.WEIXIN.getCode());
				//留着后续微信端需要国际化
//				internationalizationUtil.addInternationalization(a);
			}
		}else{
			PortalNavigate pn = portalNavigateService.selectById(vo.getId());
			pn.setShowName(vo.getShowName());
			pn.setImgPath(vo.getImgPath());
			pn.setRelationFunc(vo.getRelationFunc());
			pn.setRelationFuncCode(vo.getRelationFuncCode());
			pn.setRelationFuncName(vo.getRelationFuncName());
			pn.setRelationFuncUrl(vo.getRelationFuncUrl());
			pn.setDisplay(vo.getDisplay());
			pn.setUpdateById(context.getAccountId());
			pn.setUpdateByName(context.getAccountName());
			pn.setUpdateTime(new Date());
            pn.setRelationId(vo.getRelationId());
			// add lingye @2019-12-4
			pn.setRelationNum(vo.getRelationNum()!=null?vo.getRelationNum():"0");
			if (portalNavigateService.updateById(pn)){
				//同时修改国际化对应记录
				InternationalizationVo a = new InternationalizationVo();
				a.setName(vo.getShowName());
				a.setTableType(ClassUtils.getTableName(PortalNavigate.class));
				a.setTaskId(vo.getId());
				internationalizationUtil.updateInternationalization(a);
			}
		}
		return true;
	}
	
	@Override
	public boolean deleteNavigate(NavigateListVO vo) {
		Long accontId = vo.getAccountId();
		String accountName = vo.getAccountName();
		copyHome(vo.getHomeId(), accontId, accountName);
		boolean result = portalNavigateService.deleteById(vo.getId());
		if (result) {
			//同时删除国际化对应记录
			InternationalizationVo a = new InternationalizationVo();
			a.setTableType(ClassUtils.getTableName(PortalNavigate.class));
			a.setTaskId(vo.getId());
			internationalizationUtil.deletedInternationalization(a);
		}
		return result;
	}
	
	@Override
	public boolean insertListNavigate(NavigateInsertListVO vo) {
		Long accontId = vo.getContext().getAccountId();
		String accountName = vo.getContext().getAccountName();
		copyHome(vo.getHomeId(), accontId, accountName);
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", vo.getHomeId());
		map.put("state", SiteConstant.FIRST);
		portalNavigateService.deleteByMap(map);
		
		List<PortalNavigate> list = new ArrayList<PortalNavigate>();
		List<NavigateListVO> voList = vo.getNavigateList();
		if(voList.size() > 0) {
			NavigateListVO nvo = null;
			PortalNavigate pn = null;
			for(int i = 0; i < voList.size(); i++){
				nvo = voList.get(i);
				pn = new PortalNavigate();
				BeanUtils.copyProperties(nvo, pn);
				pn.setId(idGenerator.generate());
				pn.setSort(i + 1);
				pn.setState(SiteConstant.FIRST);
				pn.setCreateById(accontId);
				pn.setCreateByName(accountName);
				pn.setCreateTime(new Date());
				pn.setUpdateById(accontId);
				pn.setUpdateByName(accountName);
				pn.setUpdateTime(new Date());
				list.add(pn);
			}
		}
		if(list.size() > 0){
			portalNavigateService.insertBatch(list);
		}
		return true;
	}
	
	@Override
	public List<ImageListVO> listImage(Long homeId) {
		return homeImageMapper.listImage(homeId);
	}

	@Override
	public boolean deleteBannerImage(HomeImageListVO vo) {
		Long imageId = vo.getImageId();
		Long homeId = vo.getHomeId();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", homeId);
        map.put("image_id",imageId);
		return homeImageService.deleteByMap(map);
	}

	@Override
	public String previewImage(Long imageId) {
		PortalImage selectById = portalImageService.selectById(imageId);
		if(selectById == null){
			return null;
		}
		return selectById.getBannerPath();
	}

	@Override
	public Page<ImageListVO> selectBannerImage(PageParamVO vo) {
		Long terminalId = vo.getId();
		PortalTerminal portalTerminal = portalTerminalService.selectById(terminalId);
		if(portalTerminal == null){
			return null;
		}
//		if(portalTerminal.getTerminalName().equals("移动端")){
//			Long siteId = portalTerminal.getSiteId();
//			Long companyId = portalTerminal.getCompanyId();
//			Map<String, Object> map = new HashMap<String, Object>();
//			map.put("site_id", siteId);
//			map.put("company_id", companyId);
//			map.put("terminal_name", "APP");
//			List<PortalTerminalEntityVo> selectByMap = portalTerminalService.selectByMap(map);
//			if(selectByMap == null || selectByMap.size() == 0){
//				return null;
//			}
//			terminalId = selectByMap.get(0).getId();
//		}
		Page<ImageListVO> page = new Page<ImageListVO>(vo.getPageNo(), vo.getPageSize());
		List<ImageListVO> list = portalBannerMapper.selectBannerImage(page, terminalId);
		return page.setRecords(list);
	}

	@Override
	public boolean insertBannerImageList(InsertListVO vo) {
		Long accontId = vo.getContext().getAccountId();
		String accountName = vo.getContext().getAccountName();
		Long homeId = vo.getHomeId();
		Long siteId = vo.getSiteId();
		copyHome(homeId, accontId, accountName);
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", vo.getHomeId());
		map.put("state", SiteConstant.FIRST);
		homeImageService.deleteByMap(map);
		
		List<HomeImage> list = new ArrayList<HomeImage>();
		List<Long> ids = vo.getIds();
		HomeImage tb = null;
		Date date = new Date();
		// 初始化一个排序初始值
		int sort = 0;
		for(Long imageId : ids){
            sort++;
			tb = new HomeImage();
			tb.setId(idGenerator.generate());
			tb.setHomeId(homeId);
			tb.setSiteId(siteId);
			tb.setImageId(imageId);
			tb.setState(SiteConstant.FIRST);
			tb.setCreateById(accontId);
			tb.setCreateByName(accountName);
			tb.setCreateTime(date);
			tb.setUpdateById(accontId);
			tb.setUpdateByName(accountName);
			tb.setUpdateTime(date);
			tb.setSort(sort);
			list.add(tb);
		}
		if(list.size() > 0){
			homeImageService.insertBatch(list);
		}
		return true;
	}

	@Override
	public TemplateAddVO insertTemplate(TemplateAddVO vo) {
	    log.info("传过来的参数："+vo);
        System.out.println(vo.getHomeId());
		Long accontId = vo.getContext().getAccountId();
		String accountName = vo.getContext().getAccountName();
		Long homeId = vo.getHomeId();

//		copyHome(homeId, accontId, accountName);
		
		PortalTemplate pt = new PortalTemplate();
		Date date = new Date();
		Long id = idGenerator.generate();
		pt.setId(id);
		pt.setHomeId(homeId);
		pt.setSiteId(vo.getSiteId());
		pt.setModuleType(vo.getModuleType());
		pt.setState(SiteConstant.FIRST);
		pt.setCreateById(accontId);
		pt.setCreateByName(accountName);
		pt.setCreateTime(date);
		pt.setUpdateById(accontId);
		pt.setUpdateByName(accountName);
		pt.setUpdateTime(date);
		pt.setDisplay(SiteConstant.FIRST);
        if(vo.getId()!=null){
            Integer sort = portalTemplateService.selectById(vo.getId()).getSort();
            List<PortalTemplate> templatesList = getPortalTemplate(homeId, sort);


            if (CollectionUtils.isNotEmpty(templatesList)) {
                pt.setSort(templatesList.get(0).getSort());
                // 模块的顺序加1
                templatesList.parallelStream().map(template -> {
                    template.setSort(template.getSort()+ Constants.YES_FLAG);
                    return template;
                }).collect(Collectors.toList());
                portalTemplateService.updateBatchById(templatesList);
            }else {
                pt.setSort(sort+Constants.YES_FLAG);
            }

        } else {
            pt.setSort(Constants.YES_FLAG);
        }
		// 获取最大的排序
//		Integer maxSort = portalTemplateMapper.getMaxSort(homeId);
//        log.info("maxSort："+maxSort);
//            pt.setSort(maxSort==null?1:maxSort+1);
        if (portalTemplateService.insert(pt)){
			//同时添加国际化记录
			Internationalization a = new Internationalization();
			a.setName("模块名初始化");
			a.setModuleName(ModuleType.PORTAL.getName());
			a.setModuleType(ModuleType.PORTAL.getCode());
			a.setTableType(ClassUtils.getTableName(PortalTemplate.class));
			a.setTaskId(id);
			a.setTerminalType(TerminalType.WEIXIN.getCode());
			//留着后续微信端需要国际化
//        	internationalizationUtil.addInternationalization(a);
		}

		vo.setId(id);
		return vo;
	}

	@Override
	public boolean deleteTemplate(PortalTemplate pt) {
		Long accountId = pt.getUpdateById();
		String accountName = pt.getUpdateByName();
		Long templateId = pt.getId(), homeId = pt.getHomeId();
		copyHome(homeId, accountId, accountName);
		if (portalTemplateService.deleteById(templateId)){
			//同时删除国际化对应记录
			InternationalizationVo a = new InternationalizationVo();
			a.setTableType(ClassUtils.getTableName(PortalTemplate.class));
			a.setTaskId(templateId);
			internationalizationUtil.deletedInternationalization(a);
		}
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("template_id", templateId);
		map.put("state", SiteConstant.FIRST);
		protalPlateService.deleteByMap(map);
		templateCourseService.deleteByMap(map);
		return true;
	}

	@Override
	public TemplateListVO viewTemplate(Long templateId) {
		TemplateListVO vo = new TemplateListVO();
		PortalTemplate pt = portalTemplateService.selectById(templateId);
		vo.setId(pt.getId());
		vo.setHomeId(pt.getHomeId());
		vo.setSiteId(pt.getSiteId());
		vo.setModuleName(pt.getModuleName());
		vo.setModuleType(pt.getModuleType());
		vo.setSelectProject(pt.getSelectProject());
		vo.setNum(pt.getNum());
		
		List<PlateListVO> plList = new ArrayList<PlateListVO>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("template_id", templateId);
		map.put("state", SiteConstant.FIRST);
		List<ProtalPlate> selectByMap = protalPlateService.selectByMap(map);
		PlateListVO pvo = null;
		for(ProtalPlate pp : selectByMap){
			pvo = new PlateListVO();
			BeanUtils.copyProperties(pp, pvo, "createTime", "createById", "createByName", "updateTime", "updateById", "updateByName");
			plList.add(pvo);
		}
		vo.setPlateList(plList);
		
		List<PopCourseListVO> cList = new ArrayList<PopCourseListVO>();
		List<TemplateCourse> courseList = templateCourseService.selectByMap(map);
		PopCourseListVO cvo = null;
		for(TemplateCourse tc : courseList){
			cvo = new PopCourseListVO();
			cvo.setId(tc.getId());
			cvo.setName(tc.getName());
			cvo.setDisplay(tc.getDisplay());
			cList.add(cvo);
		}
		vo.setCourseList(cList);
//		vo.setPopularCourseList(cList);
		
		return vo;
	}
	
	public boolean copyHome(Long homeId, Long accontId, String accountName){
		PortalHome home = portalHomeService.selectById(homeId);
		if(home != null){
			if(home.getState() == SiteConstant.TWO){
				portalHomeService.copyHome(home);
				home.setState(SiteConstant.FIRST);
				home.setUpdateById(accontId);
				home.setUpdateByName(accountName);
				home.setUpdateTime(new Date());
				portalHomeService.updateById(home);
			}
		}
		return true;
	}

	@Override
	public Long updateTemplate(TemplateUpdateVO vo) {
		RequestContext requestContext = vo.getContext();
		Long accountId = requestContext.getAccountId();
		String accountName = requestContext.getAccountName();
		copyHome(vo.getHomeId(), accountId, accountName);
		
		PortalTemplate pt = portalTemplateService.selectById(vo.getId());
		pt.setHomeId(vo.getHomeId());
		pt.setSiteId(vo.getSiteId());
		pt.setModuleType(vo.getModuleType());
		pt.setModuleName(vo.getModuleName());
		//和培训项目没关系了
		/*pt.setSelectProject(vo.getSelectProject());
		pt.setSelectProjectName(vo.getSelectProjectName());*/
		pt.setNum(vo.getNum());
		pt.setUpdateById(accountId);
		pt.setUpdateByName(accountName);
		pt.setUpdateTime(new Date());
		if (portalTemplateService.updateById(pt)) {
            //同时修改国际化对应记录
			InternationalizationVo a = new InternationalizationVo();
			a.setName(pt.getModuleName());
			a.setTableType(ClassUtils.getTableName(PortalTemplate.class));
			a.setTaskId(vo.getId());
			internationalizationUtil.updateInternationalization(a);
		}
		
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("template_id", pt.getId());
		map.put("state", SiteConstant.FIRST);
		protalPlateService.deleteByMap(map);
		
		List<ProtalPlate> updateList = new ArrayList<ProtalPlate>();
		List<PlateListVO> plateVoList = vo.getPlateList();
		if(CollectionUtils.isNotEmpty(plateVoList)){
			ProtalPlate pp = null;
//			if (vo.getModuleType().equals(PortalEnum.FOUR.ordinal())){
//			    //移动端讲师库值能保存4个
//                plateVoList = plateVoList.stream().limit(PortalEnum.FOUR.ordinal()).collect(Collectors.toList());
//                log.info("讲师库的列表："+plateVoList);
//            }
            // 初始化
            int a =PortalEnum.ONE.toValue();
			for(PlateListVO pvo : plateVoList){
                log.info("参数"+pvo);
                pvo.setTemplateId(vo.getId());
//			    if (pvo.getTemplateId()==null){
//			        log.info("参数templateId:"+pvo.getTemplateId());
//			        continue;
//                }
				pp = new ProtalPlate();
				BeanUtils.copyProperties(pvo, pp);
				pp.setId(idGenerator.generate());
				pp.setIsRecommend(SiteConstant.FIRST);
				if(vo.getModuleType() == 1){
					pp.setLinkContent(pvo.getSelectActivity());
					pp.setLinkContentName(pvo.getSelectActivityName());
					pp.setLinkType(pvo.getActivityType());
					if(pvo.getActivityType()==13) {
						Long activityId=idGenerator.generate();
						//外链生成id，因为没有活动id
						pp.setSelectActivity(activityId);
						pp.setLinkContent(activityId);
						//外链的url
						pp.setSelectActivityName(pvo.getSelectActivityName());
						//外链的名字
						pp.setLinkContentName(pvo.getLinkContentName());
					}
				} else {
				    pp.setLinkContent(pvo.getLinkContent());
                    pp.setLinkContentName(pvo.getLinkContentName());
                }
				pp.setState(SiteConstant.FIRST);
				pp.setUpdateById(accountId);
				pp.setUpdateByName(accountName);
				pp.setUpdateTime(new Date());
				pp.setSort(a);
				updateList.add(pp);
				a++;
			}
		}
		if(updateList.size() > 0){
			protalPlateService.insertBatch(updateList);
		}
		return vo.getId();
	}

	@Override
	public Long insertHomeLogo(HomeLogoVO vo) {
		Long accountId = vo.getContext().getAccountId();
		String accountName = vo.getContext().getAccountName();
		copyHome(vo.getHomeId(), accountId, accountName);
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", vo.getHomeId());
		map.put("state", SiteConstant.FIRST);
		homeLogoService.deleteByMap(map);
		
		Date date = new Date();
		HomeLogo hl = new HomeLogo();
		Long id = idGenerator.generate();
		hl.setId(id);
		hl.setHomeId(vo.getHomeId());
		hl.setLogoPath(vo.getLogoPath());
		hl.setState(SiteConstant.FIRST);
		hl.setCreateById(accountId);
		hl.setCreateByName(accountName);
		hl.setCreateTime(date);
		hl.setUpdateById(accountId);
		hl.setUpdateByName(accountName);
		hl.setUpdateTime(date);
		homeLogoService.insert(hl);
		
		return id;
	}

	@Override
	public Long updateHomeLogo(HomeLogoVO vo) {
		Long accountId = vo.getContext().getAccountId();
		String accountName = vo.getContext().getAccountName();
		copyHome(vo.getHomeId(), accountId, accountName);
		HomeLogo selectById = homeLogoService.selectById(vo.getId());
		selectById.setLogoPath(vo.getLogoPath());
		selectById.setState(SiteConstant.FIRST);
		selectById.setUpdateById(accountId);
		selectById.setUpdateByName(accountName);
		selectById.setUpdateTime(new Date());
		homeLogoService.updateById(selectById);
		
		return vo.getId();
	}

	@Override
	public HomeLogoVO viewHomeLogo(Long homeId) {
		HomeLogoVO vo = new HomeLogoVO();
		
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", homeId);
		map.put("state", SiteConstant.FIRST);
		List<HomeLogo> selectByMap = homeLogoService.selectByMap(map);
		if(selectByMap.size() == 0){
			map.put("state", SiteConstant.TWO);
			selectByMap = homeLogoService.selectByMap(map);
		}
		if(selectByMap.size() > 0){
			HomeLogo homeLogo = selectByMap.get(0);
			vo.setId(homeLogo.getId());
			vo.setHomeId(homeLogo.getHomeId());
			vo.setLogoPath(homeLogo.getLogoPath());
			return vo;
		}
		return null;
	}

	@Override
	public Page<AnnouncementVO> selectAnnouncement(PageParamVO vo) {
		Page<AnnouncementVO> page = new Page<AnnouncementVO>(vo.getPageNo(), vo.getPageSize());
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("name", SiteConstant.ANNOUNCEMENT);
		map.put("siteId", vo.getSiteId());
		List<AnnouncementVO> list = informationMapper.selectAnnouncement(page, map);
		return page.setRecords(list);
	}

	@Override
	public PreviewImformationVO previewAnnouncement(String imformationId) {
		PreviewImformationVO vo = new PreviewImformationVO();
		Information selectById = informationMapper.selectById(imformationId);
		BeanUtils.copyProperties(selectById, vo, "createTime", "createById", "createByName", "updateTime", "updateById", "updateByName");
		return vo;
	}

	@Override
	public Page<AnnouncementVO> listAnnouncement(PageParamVO vo) {
		Page<AnnouncementVO> page = new Page<AnnouncementVO>(vo.getPageNo(), vo.getPageSize());
		List<AnnouncementVO> list = homeAnnouncementMapper.listAnnouncement(page, vo.getId());
		return page.setRecords(list);
	}

	@Override
	public Boolean deleteAnnouncement(HomeInformationListVO vo) {
		Long accountId = vo.getContext().getAccountId();
		String accountName = vo.getContext().getAccountName();
		Long homeId = vo.getHomeId();
		Long informationId = vo.getInformationId();
		copyHome(homeId, accountId, accountName);
		
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", homeId);
		map.put("information_id", informationId);
		map.put("state", SiteConstant.FIRST);
		return homeAnnouncementService.deleteByMap(map);
	}

	@Override
	public Boolean insertAnnouncementList(InsertListVO vo) {
		Long accountId = vo.getContext().getAccountId();
		String accountName = vo.getContext().getAccountName();
		Long homeId = vo.getHomeId();
		copyHome(homeId, accountId, accountName);
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("home_id", homeId);
		map.put("state", SiteConstant.FIRST);
		homeAnnouncementService.deleteByMap(map);
		
		List<HomeAnnouncement> list = new ArrayList<HomeAnnouncement>();
		List<Long> ids = vo.getIds();
		HomeAnnouncement ha = null;
		for(Long informationId : ids){
			ha = new HomeAnnouncement();
			ha.setId(idGenerator.generate());
			ha.setHomeId(homeId);
			ha.setInformationId(informationId);
			ha.setState(SiteConstant.FIRST);
			ha.setCreateById(accountId);
			ha.setCreateByName(accountName);
			ha.setCreateTime(new Date());
			ha.setUpdateById(accountId);
			ha.setUpdateByName(accountName);
			ha.setUpdateTime(new Date());
			list.add(ha);
		}
		if(list.size() > 0){
			homeAnnouncementService.insertBatch(list);
		}
		return true;
	}

	@Override
	public List<PopCourseListVO> ListTemplateCourse(Long templateId) {
		List<PopCourseListVO> list = new ArrayList<PopCourseListVO>();
		
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("template_id", templateId);
		map.put("state", SiteConstant.FIRST);
		List<TemplateCourse> selectByMap = templateCourseService.selectByMap(map);
		PopCourseListVO vo = null;
		for(TemplateCourse tc : selectByMap){
			vo = new PopCourseListVO();
			vo.setId(tc.getId());
			vo.setName(tc.getName());
			vo.setDisplay(tc.getDisplay());
			list.add(vo);
		}
		return list;
	}

	@Override
	public boolean insertTemplateCourse(CourseAddVO listVo) {
		RequestContext requestContext = listVo.getContext();
		List<TemplateCourse> list = new ArrayList<TemplateCourse>();
		Long templateId = listVo.getTemplateId();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("template_id", templateId);
		map.put("state", SiteConstant.FIRST);
		templateCourseService.deleteByMap(map);
		
		List<PopCourseListVO> courseList = listVo.getCourseList();
		TemplateCourse tc = null;
		for(PopCourseListVO vo : courseList){
			tc = new TemplateCourse();
			tc.setId(idGenerator.generate());
			tc.setTemplateId(templateId);
			tc.setName(vo.getName());
			tc.setDisplay(vo.getDisplay());
			tc.setState(SiteConstant.FIRST);
			tc.setCreateById(requestContext.getAccountId());
			tc.setCreateByName(requestContext.getAccountName());
			tc.setCreateTime(new Date());
			tc.setUpdateById(requestContext.getAccountId());
			tc.setUpdateByName(requestContext.getAccountName());
			tc.setUpdateTime(new Date());
			list.add(tc);
		}
		if(list.size() > 0){
			templateCourseService.insertBatch(list);
		}
		return true;
	}

	@Override
	public List<TemplateNewsVO> listSelectedNews(Long templateId) {
		return portalTemplateMapper.listSelectedNews(templateId);
	}

	@Override
	public PreviewNewsVO previewNews(Long id) {
		PreviewNewsVO vo = new PreviewNewsVO();
		Information selectById = informationMapper.selectById(id);
		BeanUtils.copyProperties(selectById, vo, "state", "siteId", "createTime", "createById", 
					"createByName", "updateTime", "updateById", "updateByName");
		return vo;
	}

	@Override
	public boolean insertTemplateNews(NewsAddVO vo) {
		List<ProtalPlate> list = new ArrayList<ProtalPlate>();
		Long templateId = vo.getTemplateId();
		protalPlateMapper.deleteNews(templateId);
		Long accountId = vo.getContext().getAccountId();
		String accountName = vo.getContext().getAccountName();
		
		List<Long> ids = vo.getIds();
		ProtalPlate pp = null;
		for(Long infoId : ids){
			pp = new ProtalPlate();
			pp.setId(idGenerator.generate());
			pp.setTemplateId(templateId);
			pp.setNewsId(infoId);
			pp.setState(SiteConstant.FIRST);
			pp.setCreateById(accountId);
			pp.setCreateByName(accountName);
			pp.setCreateTime(new Date());
			pp.setUpdateById(accountId);
			pp.setUpdateByName(accountName);
			pp.setUpdateTime(new Date());
			list.add(pp);
		}
		if(list.size() > 0){
			protalPlateService.insertBatch(list);
		}
		return true;
	}
	
	public List<PortalHome> getHomeList(Long terminalId){
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("terminal_id", terminalId);
		map.put("state", SiteConstant.FIRST);
		List<PortalHome> selectByMap = portalHomeService.selectByMap(map);
		if(selectByMap.size() == 0){
			map.put("state", SiteConstant.TWO);
			selectByMap = portalHomeService.selectByMap(map);
		}
		return selectByMap;
	}
	
	public PortalTerminal getPtByName(String terminalName, Long siteId){
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("terminal_name", terminalName);
		map.put("site_id", siteId);
		map.put("state", SiteConstant.FIRST);
		List<PortalTerminal> selectByMap = portalTerminalService.selectByMap(map);
		if(selectByMap.size() <= 0){
			return null;
		}
		return selectByMap.get(0);
	}

	@Override
	public Long getTerminalId(HomeTerminalVo htvo){
		String terminalName = htvo.getTerminalName();
		Long siteId = htvo.getContext().getSiteId();

		PortalTerminal pt = getPtByName(terminalName, siteId);
		if(pt == null){
			return null;
		}
		PortalHomeOtherVO vo = new PortalHomeOtherVO();
		List<PortalHome> homeList = getHomeList(pt.getId());
		if(homeList.size() == 0 || homeList == null){
			return null;
		}
		PortalHome ph = homeList.get(0);
		return ph.getTerminalId();
	}

    @Override
	public PortalHomeOtherVO listHomeOther(HomeTerminalVo htvo) {
		String terminalName = htvo.getTerminalName();
		Long siteId = htvo.getContext().getSiteId();

		PortalTerminal pt = getPtByName(terminalName, siteId);
		if(pt == null){
			return null;
		}
		PortalHomeOtherVO vo = new PortalHomeOtherVO();
		List<PortalHome> homeList = getHomeList(pt.getId());
		if(homeList.size() == 0 || homeList == null){
			return null;
		}
		PortalHome ph = homeList.get(0);

		// 获取各个区块显示信息
		TrPortalBlock portalBlock = new TrPortalBlock();
		portalBlock.setTerminalId(ph.getTerminalId());
		List<TrPortalBlock> portalBlocks = portalBlockService.selectList(QueryUtil.condition(portalBlock));
		// 如果数据表中没有数据返回，则返回空集合[ ]，而不会返回null
		List<PortalBlockVO> portalBlockVOS = new ArrayList<>();
		for(TrPortalBlock item : portalBlocks){
			PortalBlockVO portalBlockVO = new PortalBlockVO();
			BeanUtils.copyProperties(item,portalBlockVO);
			portalBlockVO.getBlockType();
			portalBlockVOS.add(portalBlockVO);
		}

		//首页logo
		HomeLogoVO homeLogo = homeLogoService.homeLogoList(ph.getId());

		// 底部菜单栏数据初始化
		bottomMenuInit(portalBlockVOS);

		//导航栏列表
		List<NavigateListVO> navigateList = new ArrayList<>();

		if(isDispaly(portalBlockVOS, BlockTypeCode.NAVIGATION_MENU.getCode())){
			navigateList = portalNavigateService.navigateList(ph.getId(), 1);
		}

		//轮播图列表
		List<PreviewImageVO> imageList = homeImageService.imageList(ph.getId());
		
		//公告列表
		List<AnnouncementVO> announcementList = new ArrayList<>();
		if(isDispaly(portalBlockVOS, BlockTypeCode.NOTICE.getCode())) {
			announcementList = homeAnnouncementMapper.listAnnouncement(ph.getId());
			for (AnnouncementVO avo : announcementList) {
				avo.setKind(SiteEnum.DETAIL.getValue());
				avo.setType(SiteEnum.NEWS.getValue());
			}
		}
		
		//联系我们列表
		List<PreviewContactVO> contactList = protalContactService.contactList(ph.getId());

		vo.setPortalBlockList(portalBlockVOS);
		vo.setHomeLogoVO(homeLogo);
		vo.setNavigateList(navigateList);
		vo.setAnnouncementList(announcementList);
		vo.setImageList(imageList);
		vo.setContactList(contactList);
		
		//首页精彩资讯
		List<InformationStudentVO> newsList = informationMapper.informationIndexTopList(siteId);
		vo.setNewsList(newsList);
		
		return vo;
	}

	/**
	 * 初始化底部菜单栏数据
	 * @param portalBlockVOS
	 */
	private static void bottomMenuInit(List<PortalBlockVO> portalBlockVOS) {
		if(isDispaly(portalBlockVOS, BlockTypeCode.BOTTOM_MENU.getCode())) {
			PortalBlockVO portalBlockVO = null;
			if (CollectionUtils.isEmpty(portalBlockVOS)) {
				portalBlockVO = new PortalBlockVO();
				portalBlockVO.setBlockType(BlockTypeCode.BOTTOM_MENU.getCode());
				portalBlockVO.setDisplay(1);
				portalBlockVO.setBottomMenuVOS(PortalBlockController.defaultBottomMenu);
				portalBlockVOS.add(portalBlockVO);
			} else {
				for (PortalBlockVO obj : portalBlockVOS) {
					if (obj.getBlockType().intValue() == BlockTypeCode.BOTTOM_MENU.getCode().intValue()) {
						portalBlockVO = obj;
						break;
					}
				}
			}
			List<BottomMenuVO> destList = PortalBlockController.copyList(PortalBlockController.defaultBottomMenu);
			String bottomStr = portalBlockVO.getBottomMenu();
			if(StringUtils.isNotBlank(bottomStr)){
				destList.forEach(
						item->{
							if(StringUtils.indexOf(bottomStr,item.getId().toString()) >= 0){
								item.setChecked(true);
							}else {
								item.setChecked(false);
							}
						}
				);
			}
			portalBlockVO.setBottomMenuVOS(destList);
		}else {
			if (CollectionUtils.isEmpty(portalBlockVOS)) {
				PortalBlockVO portalBlockVO = new PortalBlockVO();
				portalBlockVO.setBlockType(BlockTypeCode.BOTTOM_MENU.getCode());
				portalBlockVO.setDisplay(0);
				portalBlockVOS.add(portalBlockVO);
			}
		}
	}


	private static boolean isDispaly(List<PortalBlockVO> portalBlockVOS, Integer blockType) {
		boolean dispaly = true;
		for(PortalBlockVO obj : portalBlockVOS){
			if(obj.equals(blockType) && obj.getDisplay()==0){
				dispaly = false;
				break;
			}
		}
		return dispaly;
	}

	@Override
	public List<ApiTemplateMiddlerVO> listHomeTemplate(HomeTerminalVo htvo) {
		String terminalName = htvo.getTerminalName();
		RequestContext context = htvo.getContext();
		List<ApiTemplateMiddlerVO> templateList = null;
		PortalTerminal pt = getPtByName(terminalName, context.getSiteId());
		if(pt == null){
			return null;
		}
		List<PortalHome> homeList = getHomeList(pt.getId());
		if(homeList.size() > 0){
			PortalHome ph = homeList.get(0);
			templateList = portalTemplateService.templateApiList(ph.getId());
			log.info("八个列表"+templateList);
		}
		return templateList;
	}

	@Override
	public Long uploadBannerImage(UploadImageVO vo) {
		Long terminalId = vo.getTerminalId();
		PortalTerminal portalTerminal = portalTerminalService.selectById(terminalId);
		if(portalTerminal == null){
			return null;
		}
		if(portalTerminal.getTerminalName().equals("移动端")){
			Map<String, Object> map2 = new HashMap<String, Object>();
			map2.put("site_id", portalTerminal.getSiteId());
			map2.put("company_id", portalTerminal.getCompanyId());
			map2.put("terminal_name", "APP");
			List<PortalTerminal> selectByMap = portalTerminalService.selectByMap(map2);
			if(selectByMap ==null || selectByMap.size() == 0){
				return null;
			}
			terminalId = selectByMap.get(0).getId();
		}
		
		Integer homeType = 1;
		String bannerName = vo.getBannerName();
		//首页的类型, 1：课程  2：考试   3：培训  4：外部链接 5:活动 6:调研 7:新闻    0:不是首页
		if(bannerName.equals(SiteConstant.PORTALCOURSE)){
			homeType = 1;
		}else if(bannerName.equals(SiteConstant.PORTALEXAM)){
			homeType = 2;
		}else if(bannerName.equals(SiteConstant.PORTALTRAIN)){
			homeType = 3;
		}else if(bannerName.equals(SiteConstant.PORTALACTIVITY)){
			homeType = 5;
		}else if(bannerName.equals(SiteConstant.PORTALRESEARCH)){
			homeType = 6;
		}else if(bannerName.equals(SiteConstant.PORTALNEWS)){
			homeType = 7;
		}
		
		RequestContext requestContext = vo.getContext();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("terminal_id", terminalId);
		map.put("site_id", vo.getSiteId());
		map.put("banner_name", "首页");
		map.put("state", SiteConstant.FIRST);
		List<PortalBanner> selectByMap = portalBannerService.selectByMap(map);
		Long bannerId = null;
		if(selectByMap != null && selectByMap.size() > 0){
			bannerId = selectByMap.get(0).getId();
		}else{
			bannerId = idGenerator.generate();
			PortalBanner pb = new PortalBanner();
			pb.setId(bannerId);
			pb.setSiteId(vo.getSiteId());
			pb.setTerminalId(terminalId);
			pb.setBannerName("首页");
			pb.setState(SiteConstant.FIRST);
			pb.setCreateById(requestContext.getAccountId());
			pb.setCreateByName(requestContext.getAccountName());
			pb.setCreateTime(new Date());
			pb.setUpdateById(requestContext.getAccountId());
			pb.setUpdateByName(requestContext.getAccountName());
			pb.setUpdateTime(new Date());
			portalBannerService.insert(pb);
		}
		
		Integer sort = 1;
		Map<String, Object> map1 = new HashMap<String, Object>();
		map1.put("home_id", vo.getHomeId());
		map1.put("site_id", vo.getSiteId());
		map1.put("state", SiteConstant.FIRST);
		List<HomeImage> selectByMap2 = homeImageService.selectByMap(map1);
		if(selectByMap2 != null && selectByMap2.size() > 0){
			sort = selectByMap2.size() + 1;
		}
		
		PortalImage pi = new PortalImage();
		Long imageId = idGenerator.generate();
		pi.setId(imageId);
		pi.setBannerId(bannerId);
		pi.setImgTitle(vo.getImgTitle());
		pi.setBannerPath(vo.getBannerPath());
		pi.setLinkUrl(vo.getLinkUrl());
		pi.setAddTime(new Date());
		pi.setHomeType(homeType);
		pi.setSort(sort);
		pi.setState(SiteConstant.FIRST);
		pi.setCreateById(requestContext.getAccountId());
		pi.setCreateByName(requestContext.getAccountName());
		pi.setCreateTime(new Date());
		pi.setUpdateById(requestContext.getAccountId());
		pi.setUpdateByName(requestContext.getAccountName());
		pi.setUpdateTime(new Date());
		portalImageService.insert(pi);
		
		HomeImage hi = new HomeImage();
		hi.setId(idGenerator.generate());
		hi.setHomeId(vo.getHomeId());
		hi.setImageId(imageId);
		hi.setSiteId(vo.getSiteId());
		hi.setState(SiteConstant.FIRST);
		hi.setCreateById(requestContext.getAccountId());
		hi.setCreateByName(requestContext.getAccountName());
		hi.setCreateTime(new Date());
		hi.setUpdateById(requestContext.getAccountId());
		hi.setUpdateByName(requestContext.getAccountName());
		hi.setUpdateTime(new Date());
		homeImageService.insert(hi);
		
		return imageId;
	}

    /**
     * 拖拽轮播图
     * @param vo
     * @return
     */
	@Override
	public Boolean dragImage(IdTwoVO vo) {


      HomeImage sourseHomeImage = homeImageService.selectById(vo.getSourceId());

      HomeImage targethomeImage = homeImageService.selectById(vo.getTargetId());

      if (sourseHomeImage.getSort()!=0&&targethomeImage.getSort()!=0) {
          //执行拖拽的动作
          try {
              dragSowingImge(sourseHomeImage,targethomeImage);
          } catch (Exception e) {
             log.info("拖拽理轮播图："+e);
          }

      } else  {
          HomeImage hIm = new HomeImage();
          
          hIm.setHomeId(sourseHomeImage.getHomeId());
          hIm.setState(SiteConstant.FIRST);
          List<HomeImage> homeImageList = homeImageService.selectList(QueryUtil.condition(hIm));
          List<HomeImage> hiList = new ArrayList<HomeImage>();
          int index = SiteConstant.FIRST;
          for (HomeImage h:homeImageList){
              h.setSort(index);
              hiList.add(h);
              index++;
          }
          log.info("重新排序的列表"+hiList);
          homeImageService.updateBatchById(hiList);
      }
		return true;
	}

	@Override
	public Boolean dragNavigate(IdTwoVO vo) {
		Date date = new Date();
		Long sourceId = vo.getSourceId();
		Long targetId = vo.getTargetId();
		Long accountId = vo.getAccountId();
		String accountName = vo.getAccountName();
		PortalNavigate source = portalNavigateService.selectById(sourceId);
		PortalNavigate target = portalNavigateService.selectById(targetId);
		if(source == null || target == null){
			return false;
		}
		Integer sourceSort = source.getSort();
		Integer targetSort = target.getSort();


        // 查看navigate列表
        List<PortalNavigate> portalNavigateList = portalNavigateService.getNavigates(source.getHomeId(),targetSort,sourceSort);
            log.info("获取的导航的个数："+portalNavigateList.size());
            log.info("操作前的列表："+portalNavigateList);
            List<PortalNavigate> navList = new ArrayList<PortalNavigate>();
            for (PortalNavigate navigate : portalNavigateList){

                if (targetSort>sourceSort) {
                    if (navigate.getId().equals(source.getId())) {
                        navigate.setSort(targetSort);
                    } else {
                        navigate.setSort(navigate.getSort()-SiteConstant.FIRST);
                    }

                } else {
                    if (navigate.getId().equals(source.getId())) {
                        navigate.setSort(targetSort);
                    } else {
                        navigate.setSort(navigate.getSort()+SiteConstant.FIRST);
                    }
                }
                navList.add(navigate);
            }
            log.info("操作后的列表："+navList);
            // 批量修改顺序
            if (CollectionUtils.isNotEmpty(navList)) {
                log.info("执行批量修改.");
                portalNavigateService.updateBatchById(navList);
            }

		return true;
	}

	@Override
	public PortalLogin loginPageView(Long siteId, Integer type) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("site_id", siteId);
		map.put("type", type);
		List<PortalTerminal> selectByMap = portalTerminalService.selectByMap(map);
		if(selectByMap == null || selectByMap.size() == 0){
			return null;
		}
		Long terminalId = selectByMap.get(0).getId();
		Map<String, Object> map1 = new HashMap<String, Object>();
		map1.put("site_id", siteId);
		map1.put("terminal_id", terminalId);
		List<PortalLogin> selectByMap2 = portalLoginService.selectByMap(map1);
		if(selectByMap2 == null || selectByMap2.size() == 0){
			return null;
		}
		return selectByMap2.get(0);
	}


    /**
     * 拖拽轮播图
     * @param source
     * @param target
     * @return
     */
    public Boolean dragSowingImge(HomeImage source,HomeImage target) {
        Date date = new Date();
        Integer sourceSort = source.getSort();
        Integer targetSort = target.getSort();
        List<HomeImage> homeImageList = homeImageService.getHomeImageList(source.getHomeId(),targetSort,sourceSort);

        // 查看navigate列表
//        List<HomeImageEntityVo> homeImageList = portalNavigateService.getNavigates(source.getHomeId(),targetSort,sourceSort);
        log.info("获取的导航的个数："+homeImageList.size());
        log.info("操作前的列表："+homeImageList);
        List<HomeImage> homeImages = new ArrayList<HomeImage>();
        log.info("targetSort:"+targetSort+";sourceSort:"+sourceSort);
        for (HomeImage homeImage : homeImageList){
            log.info("targetSort:"+homeImage.getSort());
            if (targetSort>sourceSort) {
                    if (homeImage.getId().equals(source.getId())) {
                        homeImage.setSort(targetSort);
                    } else {
                        homeImage.setSort(homeImage.getSort()-SiteConstant.FIRST);
                    }
            } else {
                if (homeImage.getId().equals(source.getId())) {
                    homeImage.setSort(targetSort);
                } else {
                    homeImage.setSort(homeImage.getSort()+SiteConstant.FIRST);
                }
            }
            homeImages.add(homeImage);
        }
        log.info("操作后的列表："+homeImages);
        // 批量修改顺序
        if (CollectionUtils.isNotEmpty(homeImages)) {
            log.info("执行批量修改.");
            homeImageService.updateBatchById(homeImages);
        }

        return true;
    }

    /**
     * ------------------------------------------------分割线-------------------------------------------------------------------------------
     */
    
    /**
	 * 创建站点积分配置
	 */
	private void createSitePoint(Long siteId, Long companyId, Long createById, String createByName, Long orgId) {
		PointVo point = new PointVo();
		point.setCompanyId(companyId);
		point.setSiteId(siteId);
		point.setOrgId(orgId);
		point.setState(1);
		point.setUpdateById(createById);
		point.setUpdateByName(createByName);
		point.setUnit("积分"); 
		pointFeignClients.updateList(point); 
    }

    /**
     * 新增模块的 其他模块移动
     *
     * @param homeId
     * @param sort
     * @return
     */
    public List<PortalTemplate> getPortalTemplate(Long homeId, Integer sort) {

        PortalTemplate portalTemplate = new PortalTemplate();
        portalTemplate.setHomeId(homeId);
        portalTemplate.setState(SiteConstant.FIRST);
        EntityWrapper<PortalTemplate> wrapper = QueryUtil.condition(portalTemplate);

        wrapper.where("sort > {0}",sort);
        wrapper.orderBy("sort",true);

        return portalTemplateService.selectList(wrapper);
    }

	@Override
	public Integer canVisit(Integer type) {
    	RequestContext context = ContextHolder.get();
		PortalTerminal portalTerminal = new PortalTerminal();
		portalTerminal.setSiteId(context.getSiteId());
		portalTerminal.setState(1);
		portalTerminal.setDisplay(1);
		portalTerminal.setType(type);
		return this.baseMapper.selectCount(new EntityWrapper<>(portalTerminal));
	}
}
