package com.yizhi.site.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.controller.api.FunctionDisplayConfigApiController;
import com.yizhi.site.application.domain.FunctionDisplayConfig;
import com.yizhi.site.application.domain.SiteDic;
import com.yizhi.site.application.domain.SiteLanguage;
import com.yizhi.site.application.enums.FunctionTypeCode;
import com.yizhi.site.application.mapper.SiteLanguageMapper;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.service.IFunctionDisplayConfigService;
import com.yizhi.site.application.service.ISiteDicService;
import com.yizhi.site.application.service.ISiteLanguageService;
import com.yizhi.site.application.vo.site.PortalTemplateVO;
import com.yizhi.site.application.vo.site.SiteLanguageVO;
import org.springframework.stereotype.Service;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * (SiteLanguageEntityVo)表服务实现类
 *
 * @author lingye
 * @since 2020-08-26 14:50:46
 */
@Service
@Log4j2
public class SiteLanguageServiceImpl extends ServiceImpl<SiteLanguageMapper, SiteLanguage> implements ISiteLanguageService {
    @Resource
    private SiteLanguageMapper siteLanguageMapper;
    @Resource
    private ISiteDicService siteDicService;

    @Autowired
    private FunctionDisplayConfigApiController functionDisplayConfigApiController;

    @Autowired
    private IFunctionDisplayConfigService displayConfigService;

    private final static Long DIC_LANGUAGE_ID = 82L;

    @Override
    public Page<SiteLanguage> list(Long siteId, Long companyId, Integer pageNo, Integer pageSize, Integer status) {
        SiteLanguage siteLanguage = new SiteLanguage();
        siteLanguage.setSiteId(siteId);
        siteLanguage.setCompanyId(companyId);
        siteLanguage.setStatus(status);
        siteLanguage.setDeleted(0);
        Page<SiteLanguage> page = new Page<>(pageNo, pageSize);
        EntityWrapper<SiteLanguage> condition = QueryUtil.condition(siteLanguage);
        condition.orderBy("sort", true);
        return this.selectPage(page, condition);
    }

    @Override
    public boolean sortLanguage(PortalTemplateVO sortVO) {
        RequestContext context = ContextHolder.get();
        Integer code = sortVO.getType();
        Long id = sortVO.getId();

        SiteLanguage currentSiteLanguage = this.selectById(id);
        int currentSort = currentSiteLanguage.getSort();

        if (code == 1) {
            //上移
            SiteLanguage beforeSortSiteLanguage = this.baseMapper.getSiteLanguageBeforeSort(context.getSiteId(), currentSort);
            if (beforeSortSiteLanguage != null) {
                int beforeSort = beforeSortSiteLanguage.getSort();

                beforeSortSiteLanguage.setSort(currentSort);
                this.updateById(beforeSortSiteLanguage);

                currentSiteLanguage.setSort(beforeSort);
                this.updateById(currentSiteLanguage);
            }


        } else if (code == 0) {
            //下移
            SiteLanguage beforeSortSiteLanguage = this.baseMapper.getSiteLanguageAfterSort(context.getSiteId(), currentSort);
            if (beforeSortSiteLanguage != null) {
                int beforeSort = beforeSortSiteLanguage.getSort();
                beforeSortSiteLanguage.setSort(currentSort);
                this.updateById(beforeSortSiteLanguage);

                currentSiteLanguage.setSort(beforeSort);
                this.updateById(currentSiteLanguage);
            }
        }


        return true;
    }

    @Override
    public Page<SiteLanguageVO> getList(Integer status, Integer pageNo, Integer pageSize) {
        Page<SiteLanguageVO> siteLanguageVOPage = new Page<>();
        RequestContext context = ContextHolder.get();
        FunctionDisplayConfig functionDisplayConfig = new FunctionDisplayConfig();
        functionDisplayConfig.setFunctionType(FunctionTypeCode.LANGUAGE.getCode());
        functionDisplayConfig.setCompanyId(context.getCompanyId());
        functionDisplayConfig.setSiteId(context.getSiteId());
        List<FunctionDisplayConfig> functionDisplayConfigs = displayConfigService.selectList(QueryUtil.condition(functionDisplayConfig));
        log.info("返回的列表：{}", JSON.toJSON(functionDisplayConfigs));
        if (CollectionUtils.isEmpty(functionDisplayConfigs)) {
            synchronized (this) {
                boolean b = functionDisplayConfigApiController.initLanguageConfig(context);
                log.info("返回的结果：{}", b);
            }
        }
        Page<SiteLanguage> page = this.list(context.getSiteId(), context.getCompanyId(), pageNo, pageSize, status);
        log.info("返回的站点语言列表：{}", JSON.toJSON(page));
        SiteDic siteDic = new SiteDic();
        siteDic.setParentId(DIC_LANGUAGE_ID);
        Map<Long, SiteDic> siteDicMap = siteDicService.selectSiteDicMap(siteDic);
        log.info("当前的siteDicMap:{}", JSON.toJSON(siteDic));
        if (siteDicMap == null) {
            return siteLanguageVOPage;
        }

        List<SiteLanguageVO> siteLanguageVOS = page.getRecords().stream().map(a -> {
            SiteLanguageVO siteLanguageVO = new SiteLanguageVO();
            BeanUtils.copyProperties(a, siteLanguageVO);
            SiteDic tem = siteDicMap.get(a.getLanguageId());
            if (tem!=null) {
                siteLanguageVO.setLanguageCode(tem.getCode());
                siteLanguageVO.setLanguageName(tem.getName());
                siteLanguageVO.setLanguageImg(tem.getImgUrl());
                siteLanguageVO.setDes(tem.getDes());
                siteLanguageVO.setLanguageName(tem.getType());
                siteLanguageVO.setBackupDesc(tem.getBackupDesc());
            }
            return siteLanguageVO;
        }).collect(Collectors.toList());
        BeanUtils.copyProperties(page, siteLanguageVOPage);
        siteLanguageVOPage.setRecords(siteLanguageVOS);
        return siteLanguageVOPage;
    }
}