package com.yizhi.site.application.service.impl;

import java.util.Date;

import com.yizhi.site.application.domain.PortalBanner;
import com.yizhi.site.application.domain.PortalTerminal;
import com.yizhi.site.application.domain.Site;
import com.yizhi.site.application.domain.SiteManage;
import com.yizhi.site.application.mapper.SiteMapper;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import com.baomidou.mybatisplus.enums.SqlLike;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.PortalBannerService;
import com.yizhi.site.application.service.PortalTerminalService;
import com.yizhi.site.application.service.SiteManageService;
import com.yizhi.site.application.service.SiteService;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@Service
public class SiteServiceImpl extends ServiceImpl<SiteMapper, Site> implements SiteService {
	
	@Autowired
	IdGenerator idGenerator ;
	
	@Autowired
	SiteMapper siteMapper;
	
	@Autowired
	SiteManageService siteManageService;
	
	@Autowired
	PortalTerminalService portalTerminalService;
	
	@Autowired
	PortalBannerService portalBannerService;

	@Override
	public Page<Site> listPage(Page<Site> page) {
		Site site = new Site();
		site.setState((Integer) page.getCondition().get("state"));
		site.setUnite(0);
        EntityWrapper<Site> entityWrapper = new EntityWrapper<>(site);
        String name = (String) page.getCondition().get("name");
        if (!StringUtils.isEmpty(name)) {
            entityWrapper.like("name", name, SqlLike.DEFAULT).or().like("code", name, SqlLike.DEFAULT);
        }
        entityWrapper.orderBy("create_time", false);

        page.setTotal(siteMapper.selectCount(entityWrapper));
        page.setRecords(siteMapper.selectPage(new RowBounds(page.getOffset(), page.getLimit()), entityWrapper));

        return page;
	}

	@Override
	public Boolean insertDetail(Site site) {
		Long companyId = site.getCompanyId();
		Long orgId = site.getOrgId();
		site.setId(idGenerator.generate());
		site.setUnite(0);
		siteMapper.insert(site);
		Date date = new Date();
		PortalTerminal portalTerminal1 = new PortalTerminal();
		portalTerminal1.setId(idGenerator.generate());
		portalTerminal1.setSiteId(site.getId());
		portalTerminal1.setTerminalName("PC");
		portalTerminal1.setCompanyId(companyId);
		portalTerminal1.setOrgId(orgId);
		portalTerminal1.setCreateTime(date);
		portalTerminal1.setUpdateTime(date);
		portalTerminalService.insert(portalTerminal1);
		PortalBanner portalBanner1 = new PortalBanner();
		portalBanner1.setBannerName("首页");
		portalBanner1.setSiteId(site.getId());
		portalBanner1.setTerminalId(portalTerminal1.getId());
		portalBanner1.setId(idGenerator.generate());
		portalBanner1.setCreateTime(date);
		portalBanner1.setUpdateTime(date);
		portalBannerService.insert(portalBanner1);
		PortalBanner portalBanner2 = new PortalBanner();
		portalBanner2.setTerminalId(portalTerminal1.getId());
		portalBanner2.setId(idGenerator.generate());
		portalBanner2.setBannerName("培训");
		portalBanner2.setSiteId(site.getId());
		portalBanner2.setCreateTime(date);
		portalBanner2.setUpdateTime(date);
		portalBannerService.insert(portalBanner2);
		PortalBanner portalBanner3 = new PortalBanner();
		portalBanner3.setId(idGenerator.generate());
		portalBanner3.setTerminalId(portalTerminal1.getId());
		portalBanner3.setBannerName("课程");
		portalBanner3.setSiteId(site.getId());
		portalBanner3.setCreateTime(date);
		portalBanner3.setUpdateTime(date);
		portalBannerService.insert(portalBanner3);
		PortalBanner portalBanner4 = new PortalBanner();
		portalBanner4.setId(idGenerator.generate());
		portalBanner4.setTerminalId(portalTerminal1.getId());
		portalBanner4.setBannerName("新闻资讯");
		portalBanner4.setSiteId(site.getId());
		portalBanner4.setCreateTime(date);
		portalBanner4.setUpdateTime(date);
		portalBannerService.insert(portalBanner4);
		PortalBanner portalBanner5 = new PortalBanner();
		portalBanner5.setId(idGenerator.generate());
		portalBanner5.setTerminalId(portalTerminal1.getId());
		portalBanner5.setBannerName("营销");
		portalBanner5.setSiteId(site.getId());
		portalBanner5.setCreateTime(date);
		portalBanner5.setUpdateTime(date);
		portalBannerService.insert(portalBanner5);
		
		
		PortalTerminal portalTerminal2 = new PortalTerminal();
		portalTerminal2.setId(idGenerator.generate());
		portalTerminal2.setSiteId(site.getId());
		portalTerminal2.setTerminalName("移动端");
		portalTerminal2.setCompanyId(companyId);
		portalTerminal2.setOrgId(orgId);
		portalTerminal2.setCreateTime(date);
		portalTerminal2.setUpdateTime(date);
		portalTerminalService.insert(portalTerminal2);
		PortalBanner portalBanner11 = new PortalBanner();
		portalBanner11.setBannerName("首页");
		portalBanner11.setSiteId(site.getId());
		portalBanner11.setTerminalId(portalTerminal2.getId());
		portalBanner11.setId(idGenerator.generate());
		portalBanner11.setCreateTime(date);
		portalBanner11.setUpdateTime(date);
		portalBannerService.insert(portalBanner11);
		PortalBanner portalBanner22 = new PortalBanner();
		portalBanner22.setTerminalId(portalTerminal2.getId());
		portalBanner22.setId(idGenerator.generate());
		portalBanner22.setBannerName("培训");
		portalBanner22.setSiteId(site.getId());
		portalBanner22.setCreateTime(date);
		portalBanner22.setUpdateTime(date);
		portalBannerService.insert(portalBanner22);
		PortalBanner portalBanner33 = new PortalBanner();
		portalBanner33.setId(idGenerator.generate());
		portalBanner33.setTerminalId(portalTerminal2.getId());
		portalBanner33.setBannerName("课程");
		portalBanner33.setSiteId(site.getId());
		portalBanner33.setCreateTime(date);
		portalBanner33.setUpdateTime(date);
		portalBannerService.insert(portalBanner33);
		PortalBanner portalBanner44 = new PortalBanner();
		portalBanner44.setId(idGenerator.generate());
		portalBanner44.setTerminalId(portalTerminal2.getId());
		portalBanner44.setBannerName("新闻资讯");
		portalBanner44.setSiteId(site.getId());
		portalBanner44.setCreateTime(date);
		portalBanner44.setUpdateTime(date);
		portalBannerService.insert(portalBanner44);
		PortalBanner portalBanner55 = new PortalBanner();
		portalBanner55.setId(idGenerator.generate());
		portalBanner55.setTerminalId(portalTerminal2.getId());
		portalBanner55.setBannerName("营销");
		portalBanner55.setSiteId(site.getId());
		portalBanner55.setCreateTime(date);
		portalBanner55.setUpdateTime(date);
		portalBannerService.insert(portalBanner55);
		
		return true;
	}

	
	@Override
	public Boolean insertSiteManageStaff(Long siteId, Long accountId) {
		SiteManage siteManage = new SiteManage();
		siteManage.setId(idGenerator.generate());
		siteManage.setAccountId(accountId);
		siteManage.setSiteId(siteId);
		siteManage.setState(1);
		return siteManageService.insert(siteManage);
	}

}
