package com.yizhi.site.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.site.application.vo.domain.*;
import com.yizhi.site.application.vo.site.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name = "portal", contextId = "PortalManageFeignClients")
public interface PortalManageFeignClients {

	/**
	 * 门户列表
	 */
	@GetMapping(value = "/manage/portal/list/")
	List<TerminalListVO> listPortal(@RequestBody SiteComponyIdVO siteComponyIdVO);

	/**
	 * 门户发布
	 */
	@RequestMapping(value = "/manage/portal/release/{terminalId}", method = RequestMethod.POST)
	Long releasePortal(@PathVariable("terminalId") Long terminalId);

	/**
	 * 门户取消发布
	 */
	@RequestMapping(value = "/manage/portal/unrelease/{terminalId}", method = RequestMethod.POST)
	Long unreleasePortal(@PathVariable("terminalId") Long terminalId);

	/**
	 * 登录页配置（APP,PC,微信）
	 */
	@RequestMapping(value = "/manage/portal/login/view/{terminalId}", method = RequestMethod.GET)
    PortalLoginVo loginPageView(@PathVariable("terminalId") Long terminalId);

	/**
	 * 登录页修改（APP,PC,微信）
	 */
	@RequestMapping(value = "/manage/portal/login/updatePortalLogin", method = RequestMethod.POST)
	Long loginPageUpdate(@RequestBody PortalLoginVo pl);

	/**
	 * 登录页发布(APP, PC、微信)
	 */
	@RequestMapping(value = "/manage/portal/login/releasePortalLogin", method = RequestMethod.POST)
	Long loginPageRelease(@RequestBody PortalLoginVo pl);

	/**
	 * 首页发布（APP, PC、微信）
	 */
	@RequestMapping(value = "/manage/portal/home/release", method = RequestMethod.POST)
	Long homeRelease(@RequestBody IdOneVO vo);

	/**
	 * 头部导航栏功能入口列表
	 */
	@RequestMapping(value = "/manage/portal/navigate/listNavigate", method = RequestMethod.POST)
    HeadNavigateListVO listNavigate(@RequestBody PageParamVO vo);

	/**
	 * 头部导航栏功能入口修改
	 */
	@PostMapping("/manage/portal/navigate/updateNavigateList")
	Boolean updateNavigate(@RequestBody NavigateListVO vo);



	/**
	 * 头部导航栏功能入口新增
	 */
	@PostMapping("/manage/portal/navigate/dragNavigate")
	Boolean dragNavigate(@RequestBody IdTwoVO vo);

	/**
	 * 头部导航栏功能入口删除
	 */
	@RequestMapping(value = "/manage/portal/navigate/deletePortalNavigate", method = RequestMethod.POST)
	boolean deleteNavigate(@RequestBody NavigateListVO vo);

	/**
	 * 选择公告列表
	 */
	@PostMapping(value = "/manage/portal/home/announcement/selectAnnouncement")
	Page<AnnouncementVO> selectAnnouncement(@RequestBody PageParamVO vo);

	/**
	 * 预览公告
	 */
	@RequestMapping(value = "/manage/portal/home/announcement/previewAnnouncement/{imformationId}", method = RequestMethod.GET)
	PreviewImformationVO previewAnnouncement(@PathVariable("imformationId") String imformationId);

	/**
	 * 添加公告列表
	 */
	@RequestMapping(value = "/manage/portal/home/announcement/listAnnouncement", method = RequestMethod.POST)
	Page<AnnouncementVO> listAnnouncement(@RequestBody PageParamVO vo);

	/**
	 * 添加公告 删除
	 */
	@RequestMapping(value = "/manage/portal/home/announcement/deleteAnnouncement", method = RequestMethod.POST)
	Boolean deleteAnnouncement(@RequestBody HomeInformationListVO vo);

	@RequestMapping(value = "/manage/portal/login/insertLogin", method = RequestMethod.POST)
	Long loginPageInsert(@RequestBody PortalLoginListVO vo);

	/**
	 * 首页预览（PC、微信）
	 */
	@RequestMapping(value = "/manage/portal/home/preview/{terminalId}", method = RequestMethod.GET)
	PortalPreviewVO previewPortal(@PathVariable("terminalId") Long terminalId);

	/**
	 * 新增导航栏
	 */
	@RequestMapping(value = "/manage/portal/navigate/list/insertNavigateInsertList", method = RequestMethod.POST)
	boolean insertListNavigate(@RequestBody NavigateInsertListVO vo);

	/**
	 * 已选择轮播图片列表
	 */
	@RequestMapping(value = "/manage/portal/banner/image/listImage/{homeId}", method = RequestMethod.POST)
	List<ImageListVO> listImage(@PathVariable("homeId") Long homeId);

	/**
	 * 已选择轮播图删除
	 */
	@RequestMapping(value = "/manage/portal/banner/deleteHomeImage", method = RequestMethod.POST)
	boolean deleteBannerImage(@RequestBody HomeImageListVO vo);

	/**
	 * 已选择轮播图片预览
	 */
	@RequestMapping(value = "/manage/portal/banner/preview/{imageId}", method = RequestMethod.GET)
	String previewImage(@PathVariable("imageId") Long imageId);

	/**
	 * 选择已有图片列表
	 */
	@RequestMapping(value = "/manage/portal/banner/selectBannerImage", method = RequestMethod.POST)
	Page<ImageListVO> selectBannerImage(@RequestBody PageParamVO vo);

	/**
	 * 已选择轮播片新增集合
	 */
	@RequestMapping(value = "/manage/portal/banner/list/insertBannerImageList", method = RequestMethod.POST)
	boolean insertBannerImageList(@RequestBody InsertListVO vo);

	/**
	 * 模块新增
	 */
	@RequestMapping(value = "/manage/portal/template/insertTemplateList", method = RequestMethod.POST)
	TemplateAddVO insertTemplate(@RequestBody TemplateAddVO vo);

	/**
	 * 模块删除
	 */
	@RequestMapping(value = "/manage/portal/template/deletePortalTemplate", method = RequestMethod.POST)
	boolean deleteTemplate(@RequestBody PortalTemplateVo pt);

	/**
	 * 模块查看
	 */
	@RequestMapping(value = "/manage/portal/template/view/{templateId}", method = RequestMethod.GET)
	TemplateListVO viewTemplate(@PathVariable("templateId") Long templateId);

	/**
	 * 模块修改
	 */
	@RequestMapping(value = "/manage/portal/template/updateTemplateList", method = RequestMethod.POST)
	Long updateTemplate(@RequestBody TemplateUpdateVO vo);

	/**
	 * 热门课程分类列表
	 */
	@RequestMapping(value = "/manage/portal/template/course/ListTemplateCourse/{templateId}", method = RequestMethod.GET)
	List<PopCourseListVO> ListTemplateCourse(@PathVariable("templateId") Long templateId);

	/**
	 * 热门课程分类保存
	 */
	@RequestMapping(value = "/manage/portal/template/course/list/insertTemplateCourse", method = RequestMethod.POST)
	boolean insertTemplateCourse(@RequestBody CourseAddVO listVo);

	/**
	 * 首页logo新增
	 */
	@RequestMapping(value = "/manage/portal/home/logo/insertHomeLogo", method = RequestMethod.POST)
	Long insertHomeLogo(@RequestBody HomeLogoVO vo);

	/**
	 * 首页logo修改
	 */
	@RequestMapping(value = "/manage/portal/home/logo/updateHomeLogo", method = RequestMethod.POST)
	Long updateHomeLogo(@RequestBody HomeLogoVO vo);

	/**
	 * 首页logo 查看
	 */
	@RequestMapping(value = "/manage/portal/home/logo/viewHomeLogo/{homeId}", method = RequestMethod.GET)
	HomeLogoVO viewHomeLogo(@PathVariable("homeId") Long homeId);

	/**
	 * 添加公告 保存
	 */
	@RequestMapping(value = "/manage/portal/home/announcement/insertAnnouncementList", method = RequestMethod.POST)
	Boolean insertAnnouncementList(@RequestBody InsertListVO vo);

	/**
	 * 已选择轮播图片 拖动排序
	 */
	@PostMapping("/manage/portal/banner/image/dragImage")
	Boolean dragImage(@RequestBody IdTwoVO vo);

	/**
	 * 新闻资讯 列表
	 */
	@RequestMapping(value = "/manage/portal/template/news/listSelectedNews/{templateId}", method = RequestMethod.GET)
	List<TemplateNewsVO> listSelectedNews(@PathVariable("templateId") Long templateId);

	/**
	 * 新闻资讯 预览
	 */
	@RequestMapping(value = "/manage/portal/template/selected/previewNews/{id}", method = RequestMethod.GET)
	PreviewNewsVO previewNews(@PathVariable("id") Long id);

	/**
	 * 模板新闻资讯 保存
	 */
	@RequestMapping(value = "/manage/portal/template/insertTemplateNews", method = RequestMethod.POST)
	boolean insertTemplateNews(@RequestBody NewsAddVO vo);

	/**
	 * 上传新的轮播图片
	 */
	@RequestMapping(value = "/manage/portal/template/uploadBannerImage", method = RequestMethod.POST)
	Long uploadBannerImage(@RequestBody UploadImageVO vo);

    /**
     * 管理端微信配置
     * @param terminalId
     * @return
     */
    @GetMapping("/manage/portal/home/view")
    public PortalPreviewVO getPortalView(
            @RequestParam(name = "terminalId") Long terminalId
    );

    /**
     * 获取模块的list
     * @Date 2019-3-4 16:05:12
     * @param terminalId
     * @return
     */
    @GetMapping("/manage/portal/getManageModuleList")
    public List<PortalTemplateVo> getManageModuleList(@RequestParam(name = "terminalId") Long terminalId);

    /**
     * 首页模块拖拽
     * @param sourceId
     * @param targetId
     * @return
     */
    @ApiOperation(value = "首页模块配置拖拽")
    @PostMapping("/manage/portal/sortTemplate")
    Boolean sortTemplate(
            @RequestParam(value = "sourceId",required = true) Long sourceId,
            @RequestParam(value = "targetId",required = false) Long targetId,
            @RequestParam(value = "type",required = false) Integer type
    );

    @GetMapping("/manage/portal/getTemplateById")
	PortalTemplateVo getTemplateById(@RequestParam(name = "id") Long id);

    /**
     *
     * 管理端模块上下移动
     * @param id
     * @param type
     * @return
     */
    @GetMapping("/manage/portal/transferTemplate")
    Boolean transferTemplate(@RequestParam(name = "id") Long id,@RequestParam(name = "type") Integer type);

    /**
     *获取字典列表
     * @param code
     * @return
     */
    @GetMapping("/sitedic/list")
    List<SiteDicVo> list(@RequestParam(name = "code") String code);

    @PostMapping("/sitedic/update")
	SiteDicVo updateById(@RequestBody SiteDicVo siteDicEntityVo);

    /**
     * 获取字典实体
     * @param siteDicEntityVo
     * @return
     */
    @PostMapping("/sitedic/get")
	SiteDicVo get(@RequestBody SiteDicVo siteDicEntityVo);
    /**
     * 查询首页配置的模块的列表
     * @param terminalName 终端名称 PC 和移动端
     * @param moduleType 首页模块的类型
     * @return List
     * */
    @GetMapping("/manage/portal/homeConfigList")
    List<Long> selectHomeConfigList(
            @RequestParam("terminalName") String terminalName,
            @RequestParam("moduleType") int moduleType
    );

	/**
	 * 用于启用关闭今日任务
	 * @param id
	 * @param dispaly
	 * @return
	 */
	@GetMapping("/manage/portal/task/update")
	public Boolean taskPortalUpdate(@RequestParam("id") Long id,
									@RequestParam("dispaly") Integer dispaly);

	/**
	 * 用于微信端  是否展示今日任务模块
	 * @return
	 */
	@GetMapping("/manage/portal/task/get")
	public TaskPortalVo getTaskPortal();

	/**
	 * 移动首页配置平台报告
	 * @param paramVO
	 * @return
	 */
    @PostMapping("/manage/portal/report/save")
    public Boolean reportUpdate(@RequestBody ReportParamVO paramVO);

    /**
     * 移动首页平台报告置顶
     * @param id
     * @return
     */
    @GetMapping("/manage/portal/top")
    public Boolean top(@RequestParam("id") Long id);

    /**
     * 移动端首页平台报告删除
     * @param id
     * @return
     */
    @GetMapping("/manage/portal/delete")
    public Boolean delete(@RequestParam("id") Long id);

    /**
     * 移动端首页平台报告列表
     * @param terminalId
     * @return
     */
    @GetMapping("/manage/portal/report/list")
    public List<RelationReportVo> list(@RequestParam("terminalId") Long terminalId);

    @GetMapping("/manage/portal/report/update")
    public Boolean update(@RequestParam("id")Long id,@RequestParam("startPush")String startPush,@RequestParam("endPush")String endPush);

	/**
	 * 查询是否有关联
	 * @param siteId
	 * @param relationId
	 * @return
	 */
	@GetMapping("/manage/portal/getNavigateListByRelationId")
	List<PortalNavigateVo> getNavigateListByRelationId(@RequestParam("siteId") Long siteId,
                                                       @RequestParam("relationId") Long relationId);
}
