package com.yizhi.site.application.feign;

import com.yizhi.site.application.vo.domain.AppVersionVo;
import com.yizhi.site.application.vo.domain.SiteVo;
import com.yizhi.site.application.vo.site.SiteConfigVO;
import com.yizhi.site.application.vo.site.SystemSiteVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author admin
 */
@FeignClient(name = "portal", contextId = "SiteManageFeignClients")
public interface SiteManageFeignClients {
    /**
     * 修改网页名称和logo
     * @param siteConfigVO
     * @return
     */
    @PostMapping("/manage/site/config/update")
    SiteConfigVO update(@RequestBody SiteConfigVO siteConfigVO);

    /**
     * 获取log和name
     * @return
     */
    @GetMapping("/manage/site/config/get")
    SiteConfigVO get(@RequestBody SystemSiteVO siteVO);

    /**
     * 获取用版本控制 最新版本
     * @param siteCode
     * @param type
     * @return
     */
    @GetMapping("/appVersion/get")
    AppVersionVo getAppVersion(@RequestParam(name = "siteCode") String siteCode,
                               @RequestParam(name = "companyCode") String companyCode,
                               @RequestParam(name = "type") Integer type);
}
