package com.yizhi.site.application.feign.api;

import com.yizhi.site.application.vo.domain.*;
import com.yizhi.site.application.vo.site.HomeTerminalVo;
import com.yizhi.site.application.vo.site.PortalHomeOtherVO;
import com.yizhi.site.application.vo.site.PortalPlateVO;
import com.yizhi.site.application.vo.site.ApiTemplateMiddlerVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = "portal", contextId = "PortalApiFeignClients")
public interface PortalApiFeignClients {
	
	/**
	 * 获取登陆页面
	 */
	@GetMapping(value = "/api/portal/loginPageView")
    PortalLoginVo loginPageView(@RequestParam("siteId") Long siteId, @RequestParam("type") Integer type);
	
	/**
	 * 首页除模板外的所有信息
	 */
	@GetMapping(value = "/api/portal/listHomeOther")
    PortalHomeOtherVO listHomeOther(@RequestBody HomeTerminalVo htvo);

	/**
	 * 门户模板信息
	 */
	@GetMapping(value = "/api/portal/listHomeTemplate")
	List<ApiTemplateMiddlerVO> listHomeTemplate(@RequestBody HomeTerminalVo htvo);

	/**
	 * 获取terminalId
	 * @param htvo
	 * @return
	 */
	@GetMapping("/api/terminalId/get")
	public Long getTerminalId(@RequestBody HomeTerminalVo htvo);

    /**
     * 获取plateList
     * @param templateId
     * @return
     */
    @GetMapping(value = "/getPlate")
    List<PortalPlateVO> getPlateVOList(@RequestParam(value = "templateId") Long templateId);

	/**
	 * 根据模块id查询模块内容列表
	 * @param templateId
	 * @return
	 */
	@GetMapping(value = "/getPlateListByTemplateId")
	List<ProtalPlateVo> getPlateListByTemplateId(@RequestParam(value = "templateId") Long templateId);

    /**
     * 根据code 默认信息
     * @param code
     * @return
     */
    @GetMapping("/relation/get")
    RelationLinkVo getRelationLink(@RequestParam(name = "code") Integer code);

    /**
     * 模块快排序
     * @param id
     * @param code
     * @return
     */
    @PostMapping(value = "/sortPlate")
    boolean sortPlate( @RequestParam(name = "id", required = true) Long id,
                              @RequestParam(name = "code", required = true) String code);
    
    
    /**
     * 各个模块的搜索记录
     * @param trSearchRecorde
     * @return
     */
    @PostMapping(value="/search/recorde/list")
    List<String> getSearchRecorde(@RequestBody TrSearchRecordeVo trSearchRecorde);
    
    /**
     * 各个模块的搜索记录
     * @param trSearchRecorde
     * @return
     */
    @PostMapping(value="/search/recorde/save")
    Boolean saveSearchRecorde(@RequestBody TrSearchRecordeVo trSearchRecorde);
    
    
    /**
     * 各个模块的搜索记录
     * @param trSearchRecorde
     * @return
     */
    @PostMapping(value="/search/recorde/delete")
    Boolean deleteSearchRecorde(@RequestBody TrSearchRecordeVo trSearchRecorde);
    
    @GetMapping("/getReport")
    public RelationReportVo getReport(@RequestParam("terminalType") Integer terminalType);

}
