package com.yizhi.site.application.vo.domain;


import java.io.Serializable;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "InformationEntityVo", description = "资讯")
@Data
public class InformationVo{

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主鍵")
	private Long id;

	@ApiModelProperty(value = "封面logo")
	private String logoPath;

	@ApiModelProperty(value = "编号")
	private String number;

	@ApiModelProperty(value = "文章名称")
	private String fileName;

	@ApiModelProperty(value = "文章父类型  1： 新闻   2: 公告")
	private Long typeOne;


	private String typeOneName;

	@ApiModelProperty(value = "文章子类型")
	private Long typeTwo;

	private String typeTwoName;

	@ApiModelProperty(value = "作者")
	private String author;

	@ApiModelProperty(value = "发布时间")
	private Date releaseTime;

	@ApiModelProperty(value = "内容")
	private String content;

	@ApiModelProperty(value = "原文链接")
	private String linkUrl;

	@ApiModelProperty(value = "自定义关键字")
	private String keyWords;
	
	@ApiModelProperty(value = "置顶状态, 0: 未置顶 1:置顶")
	private Long isTop;

	@ApiModelProperty(value = "状态 0 删除 1 未发布 2 发布")
	private Integer state;

	@ApiModelProperty(value = "站点ID")
	private Long siteId;

	@ApiModelProperty(value = "创建时间")
	private Date createTime;

	@ApiModelProperty(value = "创建人")
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	private Date updateTime;

	@ApiModelProperty(value = "修改人")
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	private String updateByName;

	@ApiModelProperty(value = "上传的pdfOss路径")
	private String pdfOssUrl;

	@ApiModelProperty(value = "上传的pdf文件名")
	private String pdfFileName;

	@ApiModelProperty(value = "文章第三层类型")
	private Long typeThree;
	
	@ApiModelProperty(value = "副标题")
	private String titleSub;
	
	@ApiModelProperty(value = "图片来源")
	private String imgSource;

	@ApiModelProperty(value = "信息来源")
	private String source;

	private String typeThreeName;

	@ApiModelProperty(value = "资讯分类")
	private List<InformationClassify> informationClassify;

	@ApiModelProperty(value = "阅读数量")
	private Integer readNum = 0;

	@ApiModelProperty(value = "阅读人数")
	private Integer readDistinctNum = 0;
	
	@ApiModelProperty(value = "点赞数量")
	private Integer admireNum = 0;

	@ApiModelProperty(value = "收藏数量")
	private Integer favoriteNum = 0;

	@ApiModelProperty(value = "转发数量")
	private Integer relayNum = 0;

	@ApiModelProperty(value = "专题")
	private String topic;

	protected Serializable pkVal() {
		return this.id;
	}
}