package com.yizhi.site.application.vo.domain;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-03-27
 */
@ApiModel(value = "SiteEntityVo", description = "站点")
@Data
public class SiteVo {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "站点名称")
	private String name;

	@ApiModelProperty(value = "站点编码")
	private String code;

	@ApiModelProperty(value = "存放路径")
	private String logoPath;

	@ApiModelProperty(value = "站点前台访问地址")
	private String receptionAdd;

	@ApiModelProperty(value = "自定义访问地址")
	private String customizeAdd;

	@ApiModelProperty(value = "关联部门, 多个用，隔开")
	private Long relatedOrg;

	@ApiModelProperty(value = "0停用 1启用")
	private Integer state;

	@ApiModelProperty(value = "0不是 1是")
	private Integer main;

	@ApiModelProperty(value = "父站点ID")
	private Long parentId;

	@ApiModelProperty(value = "创建时间")
	private Date createTime;

	@ApiModelProperty(value = "创建人ID")
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	private Date updateTime;

	@ApiModelProperty(value = "修改人ID")
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	private String updateByName;

	@ApiModelProperty(value = "公司ID")
	private Long companyId;

	@ApiModelProperty(value = "1: 统一站点  0: 多站点")
	private Integer unite;

	@ApiModelProperty(value = "部门ID")
	private Long orgId;

	protected Serializable pkVal() {
		return this.id;
	}
}
