package com.yizhi.site.application.vo.site;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.util.Date;

/**
 * @description: 管理后台返回
 * @author: lly
 * @date: 2019-3-11
 **/
@Data
@ApiModel(value =  "管理后台返回")
public class TemplatePlateVO implements Serializable {
    @ApiModelProperty(value = "列表id")
    private Long id;

    @ApiModelProperty(value = "名称")
    private String linkContentName;
    @ApiModelProperty(value = "展示图片")
    private String imgPath;
    @ApiModelProperty(value = "开始时间")
    private Date startTime;
    @ApiModelProperty(value = "结束时间")
    private Date endTime;
    @ApiModelProperty(value = "课程学习人数")
    private Integer viewCount;
    @ApiModelProperty(value = "评价分")
    private String score;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty(value = "url")
    private String url;

    private Integer thumbnail;

    @ApiModelProperty(value = "homeId")
    private Long homeId;

    @ApiModelProperty(value = "templateId")
    private Long templateId;

    @ApiModelProperty(value = "模块名字")
    private String moduleName;

    @ApiModelProperty(value = "站点id")
    private Long siteId;

    @ApiModelProperty(value = "课程编码")
    private String courseNo;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "讲师头衔")
    private String title;

    @ApiModelProperty(value = "创建人")
    private String createByName;
    
	@ApiModelProperty(value = "说明  moduleType=专区 ,存放code")
	private String directions;

    @ApiModelProperty(value = "1:上架 0：下架")
    private Integer status;

    @ApiModelProperty(value = "观看类型：0: 公开播放 ; 1: 站内授权播放; ")
    private Integer viewType;

}
