package com.yizhi.site.application.controller;


import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.site.application.domain.PortalThemeColor;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.service.IPortalThemeColorService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * <p>
 * 门户主题色配置 前端控制器
 * </p>
 *
 * @author fulan123
 * @since 2020-08-12
 */
@RestController
@RequestMapping("/theme/color")
public class PortalThemeColorController {

    private static final String THEME_COLOR_DEFAULT = "#4285F4"; //主题默认色
    private static final String AUXILIAR_COLOR_DEFAULT = "#7D4601"; // 辅助色默认

    @Autowired
    private IPortalThemeColorService portalThemeColorService;

    @Autowired
    private IdGenerator idGenerator;

    /**
     * 根据站点和终端类型查询系统设置的颜色
     * @param companyId
     * @param siteId
     * @param terminalType
     * @return
     */
    @GetMapping("/get")
    public PortalThemeColor getThemeColorBySiteId(@RequestParam(value = "companyId") Long companyId,
                                                  @RequestParam(value = "siteId") Long siteId,
                                                  @RequestParam(value = "terminalType") Integer terminalType){
        EntityWrapper<PortalThemeColor> ew = QueryUtil.condition(new PortalThemeColor());
        ew.eq("company_id",companyId).eq("site_id",siteId).eq("terminal_type", terminalType);
        PortalThemeColor portalThemeColor = portalThemeColorService.selectOne(ew);

        // 如果不存在就返回默认颜色
        if(portalThemeColor == null){
            portalThemeColor = new PortalThemeColor();
            portalThemeColor.setCompanyId(companyId);
            portalThemeColor.setSiteId(siteId);
            portalThemeColor.setTerminalType(terminalType);
            portalThemeColor.setThemeColor(THEME_COLOR_DEFAULT);
            portalThemeColor.setAuxiliarColor(AUXILIAR_COLOR_DEFAULT);
        }
        return portalThemeColor;
    }

    /**
     * 根据主键重置
     * @param id
     * @return
     */
    @GetMapping("/reset")
    public Boolean reset(@RequestParam(value = "id") Long id,
                                  @RequestParam(value = "accountId") Long accountId){

        PortalThemeColor portalThemeColor = portalThemeColorService.selectById(id);
        if(portalThemeColor != null){
            portalThemeColor.setUpdateById(accountId);
            portalThemeColor.setUpdateTime(new Date());
            portalThemeColor.setThemeColor(THEME_COLOR_DEFAULT);
            portalThemeColor.setAuxiliarColor(AUXILIAR_COLOR_DEFAULT);
            portalThemeColorService.updateById(portalThemeColor);
        }

        return true;
    }

    /**
     * 保存主题颜色配置
     * @param portalThemeColor
     * @return
     */
    @PostMapping("/save")
    public PortalThemeColor save(@RequestBody PortalThemeColor portalThemeColor){
        EntityWrapper<PortalThemeColor> ew = QueryUtil.condition(new PortalThemeColor());
        ew.eq("company_id",portalThemeColor.getCompanyId())
                .eq("site_id",portalThemeColor.getSiteId())
                .eq("terminal_type", portalThemeColor.getTerminalType());

        PortalThemeColor portalThemeColorDb = portalThemeColorService.selectOne(ew);
        if(null == portalThemeColorDb){
            portalThemeColorDb = new PortalThemeColor();
            BeanUtils.copyProperties(portalThemeColor,portalThemeColorDb);
            portalThemeColorDb.setId(idGenerator.generate());
            portalThemeColorDb.setCreateTime(new Date());
            portalThemeColorService.insert(portalThemeColorDb);
        }else {
            portalThemeColorDb.setUpdateById(portalThemeColor.getCreateById());
            portalThemeColorDb.setUpdateTime(new Date());
            portalThemeColorDb.setThemeColor(portalThemeColor.getThemeColor());
            portalThemeColorDb.setAuxiliarColor(portalThemeColor.getAuxiliarColor());
            portalThemeColorService.updateById(portalThemeColorDb);
        }

        return portalThemeColorDb;
    }

}

