package com.yizhi.site.application.controller;


import com.yizhi.site.application.domain.SiteConfig;
import com.yizhi.site.application.service.ISiteConfigService;
import com.yizhi.site.application.vo.site.SiteConfigVO;
import com.yizhi.site.application.vo.site.SystemSiteVO;
import com.yizhi.system.application.vo.SiteVO;
import io.swagger.annotations.Api;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 网页名称的配置
 * </p>
 *
 * @author lilingye
 * @since 2019年7月5日
 */
@Api(tags = "网页名称的配置", description = "网页名称的配置")
@RestController
@RequestMapping("/manage/site/config")
public class SiteConfigController {

    @Autowired
    ISiteConfigService siteConfigService;

    /**
     * 更新网站的信息
     * @param siteConfigVO
     * @return
     */
    @PostMapping("/update")
    public SiteConfigVO update(@RequestBody SiteConfigVO siteConfigVO) {
        return siteConfigService.update(siteConfigVO);
    }

    /**
     * 获取网站的信息
     * @return
     */
    @GetMapping("/get")
    public SiteConfigVO get(@RequestBody SystemSiteVO siteVO) {
        SiteConfigVO siteConfigVO = new SiteConfigVO();
        SiteConfig siteConfig = siteConfigService.get(siteVO);
        BeanUtils.copyProperties(siteConfig,siteConfigVO);
        return siteConfigVO;
    }

}

