package com.yizhi.site.application.controller;

import com.yizhi.site.application.domain.SiteDic;
import com.yizhi.site.application.service.ISiteDicService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 资讯管理，前端控制器
 * </p>
 *
 * @author lingye
 * @since 2019-4-29
 */
@Api(tags = "门户字典", description = "字典")
@RestController
@RequestMapping("/sitedic")
public class SiteDicController {
    @Autowired
    private ISiteDicService siteDicService;

    /**
     * 获取字典列表
     *
     * @param code
     * @return
     */
    @GetMapping("/list")
    public List<SiteDic> list(@RequestParam(name = "code") String code) {
        return siteDicService.getSiteDicListByCode(code);
    }

    /**
     * 修改字典
     *
     * @param siteDic
     * @return
     */
    @PostMapping("/update")
    public SiteDic updateById(@RequestBody SiteDic siteDic) {
        return siteDicService.updateDicById(siteDic);
    }

    /**
     * 获取字典实体
     *
     * @param siteDic
     * @return
     */
    @PostMapping("/get")
    public SiteDic get(@RequestBody SiteDic siteDic) {
        return siteDicService.selectSiteDic(siteDic);
    }


}
