package com.yizhi.site.application.controller.api;


import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.domain.MyItemConfigDefault;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.site.application.service.MyItemConfigDefaultService;
import com.yizhi.site.application.vo.site.MyItemConfigVO;
import io.swagger.annotations.Api;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 'cloud_portal.institution_rank_v' is not BASE TABLE 前端控制器
 * </p>
 *
 * @author hutao123
 * @since 2019-03-11
 */
@Api(tags = "显示端-我的配置", description = "我的配置  默认配置")
@RestController
@RequestMapping("/myItemConfigDefault/api")
public class MyItemConfigDefaultApiComtroller {

    @Autowired
    MyItemConfigDefaultService myItemConfigDefaultService;
    @Autowired
    IdGenerator idGenerator;


    @GetMapping("/queryByAuthoity")
    public List<MyItemConfigVO> queryByAuthoity(@RequestParam(value = "terminalType", required = false) List<Integer> terminalType) {
        RequestContext context = ContextHolder.get();
        List<MyItemConfigDefault> itemConfig = myItemConfigDefaultService.queryByAuthoity(context.getSiteId(), terminalType);
        List<MyItemConfigVO> voList = new ArrayList<>();

        itemConfig.forEach(a -> {
            MyItemConfigVO vo = new MyItemConfigVO();
            BeanUtils.copyProperties(a, vo);
            voList.add(vo);
        });
        return voList;

    }


}

