package com.yizhi.site.application.controller.api;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.site.application.constant.SiteConstant;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.site.application.service.IRelationReportService;
import com.yizhi.site.application.service.PortalTerminalService;
import com.yizhi.site.application.service.ProtalPlateService;
import com.yizhi.site.application.service.TrSearchRecordeService;
import com.yizhi.site.application.domain.*;
import com.yizhi.site.application.vo.site.ApiTemplateMiddlerVO;
import com.yizhi.site.application.vo.site.HomeTerminalVo;
import com.yizhi.site.application.vo.site.PortalHomeOtherVO;
import com.yizhi.site.application.vo.site.PortalPlateVO;
import com.yizhi.statistics.application.entity.Report;
import com.yizhi.statistics.application.feign.ReportClient;
import com.yizhi.statistics.application.feign.StudentReportClient;
import com.yizhi.statistics.application.vo.report.ReportDetailVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

@RestController
public class PortalApiController {
	
	private Logger logger = LoggerFactory.getLogger(PortalApiController.class);
	
	@Autowired
	private PortalTerminalService portalTerminalService;
	@Autowired
    private ProtalPlateService protalPlateService;
	
	@Autowired
	private TrSearchRecordeService trSearchRecordeService;
	
    @Autowired
    private IRelationReportService relationReportService;
    
    @Autowired
    private ReportClient reportClient;

    
    @Autowired
    private StudentReportClient studentReportClient;
    
	@GetMapping(value = "/api/portal/loginPageView")
	public PortalLogin loginPageView(@RequestParam("siteId") Long siteId, @RequestParam("type") Integer type){
		return portalTerminalService.loginPageView(siteId, type);
	}
	
	@GetMapping("/api/portal/listHomeOther")
	public PortalHomeOtherVO listHomeOther(@RequestBody HomeTerminalVo htvo){
		return portalTerminalService.listHomeOther(htvo);
	}
	
	@GetMapping("/api/portal/listHomeTemplate")
	public List<ApiTemplateMiddlerVO> listHomeTemplate(@RequestBody HomeTerminalVo htvo){
		return portalTerminalService.listHomeTemplate(htvo);
	}

	@GetMapping("/api/terminalId/get")
	public Long getTerminalId(@RequestBody HomeTerminalVo htvo){
		return portalTerminalService.getTerminalId(htvo);
	}

    @GetMapping(value = "/getPlate")
    public List<PortalPlateVO> getPlateVOList(@RequestParam(value = "templateId") Long templateId){
        return protalPlateService.getPlateVOList(templateId);
    }

	/**
	 * 根据模块id查询模块内容列表
	 * @param templateId
	 * @return
	 */
	@GetMapping(value = "/getPlateListByTemplateId")
	public List<ProtalPlate> getPlateListByTemplateId(@RequestParam(value = "templateId") Long templateId){
		ProtalPlate protalPlate = new ProtalPlate();
		protalPlate.setTemplateId(templateId);
		protalPlate.setState(SiteConstant.FIRST);
		return protalPlateService.selectList(QueryUtil.condition(protalPlate));
	}

    /**
     *模块排序
     * @param id
     * @param code
     * @return
     */
    @PostMapping(value = "/sortPlate")
    public boolean sortPlate( @RequestParam(name = "id", required = true) Long id,
                                       @RequestParam(name = "code", required = true) String code){
    return protalPlateService.sortPlate(id,code);
}
    
    
    /**
     * 各个模块的搜索记录
     * @param trSearchRecorde
     * @return
     */
    @PostMapping(value="/search/recorde/list")
    List<String> getSearchRecorde(@RequestBody TrSearchRecorde trSearchRecorde){
    	return trSearchRecordeService.getSearchRecorde(trSearchRecorde);
    }
    
    /**
     * 各个模块的搜索记录
     * @param trSearchRecorde
     * @return
     */
    @PostMapping(value="/search/recorde/save")
    Boolean saveSearchRecorde(@RequestBody TrSearchRecorde trSearchRecorde){
    	return trSearchRecordeService.insertTrSearchRecorde(trSearchRecorde);
    }
    
    /**
     * 各个模块的搜索记录
     * @param trSearchRecorde
     * @return
     */
    @PostMapping(value="/search/recorde/delete")
    Boolean delteSearchRecorde(@RequestBody TrSearchRecorde trSearchRecorde){
    	return trSearchRecordeService.deleteTrSearchRecorde(trSearchRecorde);
    }

    @GetMapping("/getReport")
    public RelationReport getReport(@RequestParam("terminalType") Integer terminalType) {
    	Date date = new Date();
    	RequestContext context = ContextHolder.get();
    	Long siteId = context.getSiteId();
    	Long companyId = context.getCompanyId();
    	Long accountId = context.getAccountId();
    	PortalTerminal terminal = new PortalTerminal();
    	terminal.setSiteId(siteId);
    	terminal.setType(terminalType);
    	terminal.setState(1);
    	EntityWrapper<PortalTerminal> entityWrapper = new EntityWrapper<PortalTerminal>(terminal);
    	PortalTerminal portalTerminal = portalTerminalService.selectOne(entityWrapper);
		if (portalTerminal == null) {
			logger.info("未查询到有效终端");
			return null;
		}
    	RelationReport report = new RelationReport();
    	report.setTerminalId(portalTerminal.getId());
    	report.setState(1);
    	EntityWrapper<RelationReport> wrapper = new EntityWrapper<RelationReport>(report);
    	wrapper.orderBy("is_top", false).orderBy("create_time", false);
    	List<RelationReport> list = relationReportService.selectList(wrapper);
    	if (CollectionUtils.isNotEmpty(list)) {
			for(RelationReport one:list) {
				Report byId = reportClient.getById(one.getReportId());
				if (!byId.getState().equals(1)) {
			    	continue;
				}
				ReportDetailVO detail = studentReportClient.get(one.getReportId(), siteId, companyId, accountId);
				logger.info("首页关联的报告："+byId.toString());
				logger.info("用户数据："+detail.toString());
				//只显示推送时间段内且用户可见范围内的未查看报告
				if (null!=detail) {
					if (detail.getState().equals(0)&&one.getStartPush().before(date)&&one.getEndPush().after(date)) {
						return one;
					}
				}
			}
		}
    	return null;
    }
 }
