package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * com.yizhi.site.application.domain
 *
 * @author yanglang
 * @create 2025-01-14 10:06:55
 */
@ApiModel(value = "EventTrack", description = "埋点表")
@Data
@TableName("event_track")
public class EventTrack extends Model<EventTrack> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "埋点表ID")
    private Long id;

    @ApiModelProperty(value = "备用字段1")
    @TableField("remark1")
    private String remark1;

    @ApiModelProperty(value = "备用字段2")
    @TableField("remark2")
    private String remark2;

    @ApiModelProperty(value = "备用字段3")
    @TableField("remark3")
    private String remark3;

    @ApiModelProperty(value = "子类型")
    @TableField("sub_type")
    private String subType;

    @ApiModelProperty(value = "类型：1 登录，2 阅读文章，3 点赞收藏,4 投稿，5 问卷")
    @TableField("type")
    private Integer type;

    @ApiModelProperty(value = "部门ID")
    @TableField("dept_id")
    private Long deptId;

    @ApiModelProperty(value = "部门名称")
    @TableField("dept_name")
    private String deptName;

    @ApiModelProperty(value = "业务ID")
    @TableField("business_id")
    private Long businessId;

    @ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;

    @ApiModelProperty(value = "创建姓名")
    @TableField("create_by_name")
    private String createByName;

    @ApiModelProperty(value = "更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty(value = "更新人")
    @TableField("update_by_id")
    private Long updateById;

    @ApiModelProperty(value = "更新姓名")
    @TableField("update_by_name")
    private String updateByName;

    @ApiModelProperty(value = "删除标记1删除 0 正常")
    @TableLogic
    @TableField("deleted")
    private Integer deleted;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
