package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 显示配置---》功能项显示配置
 * </p>
 *
 * @author 谢海军123
 * @since 2019-04-29
 */
@Data
@ApiModel(value = "FunctionDisplayConfigEntityVo", description = "显示配置---》功能项显示配置")
@TableName("function_display_config")
public class FunctionDisplayConfig {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "唯一主键")
	private Long id;

    @ApiModelProperty(value = "功能名称")
	@TableField("function_name")
	private String functionName;

    @ApiModelProperty(value = "功能类型：01 课程学时显示；02 项目学时显示")
	@TableField("function_type")
	private String functionType;

    @ApiModelProperty(value = "使用的设备")
	@TableField("use_device")
	private String useDevice;

    @ApiModelProperty(value = "使用设备类型：01 pc端&移动端")
	@TableField("use_device_type")
	private String useDeviceType;

    @ApiModelProperty(value = "是否显示 0:不显示（false）；1:显示（true）")
	@TableField("show_display")
	private Boolean showDisplay;

    @ApiModelProperty(value = "企业id")
	@TableField("company_id")
	private Long companyId;

    @ApiModelProperty(value = "站点id")
	@TableField("site_id")
	private Long siteId;

    @ApiModelProperty(value = "组织id")
	@TableField("org_id")
	private Long orgId;

	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	@TableField(value = "update_by_id", fill = FieldFill.UPDATE)
	private Long updateById;

	@TableField(value = "update_by_name", fill = FieldFill.UPDATE)
	private String updateByName;

	@TableField(value = "update_time", fill = FieldFill.UPDATE)
	private Date updateTime;

    @ApiModelProperty(value = "操作日志")
	@TableField("operate_log")
	private String operateLog;



}
