package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 国际化
 * </p>
 *
 * @author lingye
 * @since 2020-08-13
 */
@Data
@Api(tags = "InternationalEntityVo", description = "")
@TableName("international")
public class International extends Model<International> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "语种id")
    @TableField("international_key_id")
    private Long internationalKeyId;

    @ApiModelProperty(value = "key值")
    @TableField("international_key")
    private String internationalKey;

    @ApiModelProperty(value = "中文字段")
    @TableField("pre_translation")
    private String preTranslation;

    @ApiModelProperty(value = "翻译后")
    @TableField(value = "post_translation", fill = FieldFill.INSERT)
    private String postTranslation;

    @ApiModelProperty(value = "备注")
    @TableField("translate_remark")
    private String translateRemark;

    @ApiModelProperty(value = "0管理端 1 移动端 2 PC端")
    private Integer type;


    @ApiModelProperty(value = "语种id")
    @TableField("language_id")
    private Long languageId;

    @ApiModelProperty(value = "创建时时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "创建人id")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "修改人id")
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @ApiModelProperty(value = "删除标记 1，删除")
    private Integer deleted;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
