package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 自定义页底-链接
 * </p>
 *
 * @author hutao123
 * @since 2019-02-21
 */
@Data
@Api(tags = "MyItemConfigEntityVo", description = "我的配置")
@TableName("my_item_config")
public class MyItemConfig extends Model<MyItemConfig> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "栏目id")
    @TableField("id")
    private Long id;

    @ApiModelProperty(value = "栏目名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "栏目code")
    @TableField("pc_code")
    private String pcCode;

    @ApiModelProperty(value = "配合前端在学员端跳转页面所需addUrl")
    @TableField("pc_add_url")
    private String pcAddUrl;

    @ApiModelProperty(value = "栏目code")
    @TableField("weixin_code")
    private String weixinCode;

    @ApiModelProperty(value = "栏目类型 1-我的培训" + "2-我的课程" + "3-我的作业" + "4-我的考试" + "5-我的调研" +
            "6-我的积分" + "7-我的做课" + "8-我的投票" + "9-我的分享" + "10-我的消息" + "11-收藏" + "12-我的证书"+"签到"+"我的收藏"
    +"13-")
    @TableField("item_type")
    private Integer itemType;

    @ApiModelProperty(value = "0 :未删除   1: 删除(默认为0) ")
    @TableField("deleted")
    private Integer deleted;

    @ApiModelProperty(value = "是否显示:0不显示,1显示（默认为0）")
    @TableField("showable")
    private Integer showable;

    @ApiModelProperty(value = "排序")
    @TableField("sort")
    private Integer sort;

    @ApiModelProperty(value = "终端类型：1-PC端、2-移动端 3-PC端&移动端")
    @TableField("terminal_type")
    private Integer terminalType;

    @ApiModelProperty(value = "站点_ID")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "创建人id")
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    @ApiModelProperty(value = "logo图标地址")
    private String logoImg;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
