package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 门户主题色配置
 * </p>
 *
 * @author fulan123
 * @since 2020-08-12
 */
@Data
@ApiModel(value = "PortalThemeColorEntityVo", description = "门户主题色配置")
@TableName("tr_portal_theme_color")
public class PortalThemeColor {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
	private Long id;

    @ApiModelProperty(value = "企业id")
	@TableField("company_id")
	private Long companyId;

    @ApiModelProperty(value = "站点id")
	@TableField("site_id")
	private Long siteId;

    @ApiModelProperty(value = "终端类型：1 后台管理端  ；2 PC端 ； 3 移动端")
	@TableField("terminal_type")
	private Integer terminalType;

    @ApiModelProperty(value = "主题色")
	@TableField("theme_color")
	private String themeColor;

    @ApiModelProperty(value = "辅助色")
	@TableField("auxiliar_color")
	private String auxiliarColor;

    @ApiModelProperty(value = "创建用户")
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

    @ApiModelProperty(value = "创建时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

    @ApiModelProperty(value = "更新用户")
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

    @ApiModelProperty(value = "更新时间")
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;



}
