package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import com.baomidou.mybatisplus.enums.IdType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 门户系统字典
 * </p>
 *
 * @author lly
 * @since 2019-4-29
 */
@Data
@ApiModel(value = "SiteDicEntityVo", description = "门户系统字典")
@TableName("site_dic")
public class SiteDic extends Model<SiteDic>{

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "记录id")
	@TableId(value="id", type= IdType.AUTO)
	private Long id;

    @ApiModelProperty(value = "父节点id")
	@TableField("parent_id")
	private Long parentId;

    @ApiModelProperty(value = "字典名称")
	private String name;

    @ApiModelProperty(value = "字典代码")
	private String code;

    @ApiModelProperty(value = "描述")
	private String des;

    @ApiModelProperty(value = "状态 1 启用 0 删除  3：下架（用于语种）")
	private String status;

    @ApiModelProperty(value = "图片")
    @TableField("img_url")
	private String imgUrl;

    @ApiModelProperty(value = "字典类型")
	private String type;

    @ApiModelProperty(value = "用于语种排序")
    private Integer sort;

    @ApiModelProperty(value = "选择语言该文案的对应语种翻译")
    @TableField(value = "backup_desc")
    private String backupDesc;

    @ApiModelProperty(value = "添加时间")
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

    @ApiModelProperty(value = "修改时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "绑定的新闻资讯的ID")
    @TableField(exist = false)
    private Long relationId;

    @Override
    protected Serializable pkVal() {
        return null;
    }
}
