package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 站点国际化语言表
 * </p>
 *
 * @author fulan123
 * @since 2020-09-11
 */
@Data
@Api(tags = "SiteLanguageEntityVo", description = "站点国际化语言表")
@TableName("site_language")
public class SiteLanguage extends Model<SiteLanguage> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "语言id")
    @TableField("language_id")
    private Long languageId;

    @ApiModelProperty(value = "公司id")
    @TableField("company_id")
    private Long companyId;

    @ApiModelProperty(value = "站点id")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "创建时间")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    @ApiModelProperty(value = "删除标记 0 正常 1 删除")
    private Integer deleted;

    @ApiModelProperty(value = "状态 0 停用 1 启用")
    private Integer status;

    @ApiModelProperty(value = "排序")
    private Integer sort;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
