package com.yizhi.site.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author bob123
 * @since 2018-04-10
 */
@ApiModel(value="TemplateCourseEntityVo", description="热门课程")
@Data
@TableName("tr_template_course")
public class TemplateCourse extends Model<TemplateCourse> {

    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value="主键id")
    private Long id;
    
    @ApiModelProperty(value="模块Id")
    @TableField("template_id")
    private Long templateId;
    
    @ApiModelProperty(value="分类名称")
    private String name;
    
    @ApiModelProperty(value="是否显示 0 不显示  1 显示")
    private Integer display;
    
    @ApiModelProperty(value="状态 0 删除 1 未删除")
    private Integer state;
    
    @ApiModelProperty(value="创建时间")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty(value="创建人")
    @TableField("create_by_id")
    private Long createById;

    @ApiModelProperty(value="创建姓名")
    @TableField("create_by_name")
    private String createByName;

    @ApiModelProperty(value="更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty(value="更新人")
    @TableField("update_by_id")
    private Long updateById;
    
    @ApiModelProperty(value="更新姓名")
    @TableField("update_by_name")
    private String updateByName;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
